/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.grid.internal.gridcolumngroupkit;

import java.io.IOException;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridColumnGroup;
import org.eclipse.nebula.widgets.grid.internal.IGridAdapter;
import org.eclipse.nebula.widgets.grid.internal.gridcolumngroupkit.GridColumnGroupOperationHandler;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCA;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.remote.JsonMapping;
import org.eclipse.rap.rwt.remote.OperationHandler;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.internal.widgets.ItemLCAUtil;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;

public class GridColumnGroupLCA
extends WidgetLCA<GridColumnGroup> {
    public static final GridColumnGroupLCA INSTANCE = new GridColumnGroupLCA();
    private static final String TYPE = "rwt.widgets.GridColumnGroup";
    private static final String[] ALLOWED_STYLES = new String[]{"TOGGLE"};
    private static final String PROP_LEFT = "left";
    private static final String PROP_WIDTH = "width";
    private static final String PROP_HEIGHT = "height";
    private static final String PROP_VISIBLE = "visibility";
    private static final String PROP_FONT = "font";
    private static final String PROP_EXPANDED = "expanded";
    private static final String PROP_HEADER_WORD_WRAP = "headerWordWrap";
    private static final String PROP_FIXED = "fixed";
    private static final String PROP_EXPAND_LISTENER = "Expand";
    private static final String PROP_COLLAPSE_LISTENER = "Collapse";
    private static final int ZERO = 0;

    public void renderInitialization(GridColumnGroup group) throws IOException {
        RemoteObject remoteObject = RemoteObjectFactory.createRemoteObject((Widget)group, (String)TYPE);
        remoteObject.setHandler((OperationHandler)new GridColumnGroupOperationHandler(group));
        remoteObject.set("parent", WidgetUtil.getId((Widget)group.getParent()));
        remoteObject.set("style", (JsonValue)JsonUtil.createJsonArray((String[])WidgetLCAUtil.getStyles((Widget)group, (String[])ALLOWED_STYLES)));
        remoteObject.listen(PROP_EXPAND_LISTENER, true);
        remoteObject.listen(PROP_COLLAPSE_LISTENER, true);
    }

    public void preserveValues(GridColumnGroup group) {
        ItemLCAUtil.preserve((Item)group);
        WidgetLCAUtil.preserveProperty((Widget)group, (String)PROP_LEFT, (int)GridColumnGroupLCA.getLeft(group));
        WidgetLCAUtil.preserveProperty((Widget)group, (String)PROP_WIDTH, (int)GridColumnGroupLCA.getWidth(group));
        WidgetLCAUtil.preserveProperty((Widget)group, (String)PROP_HEIGHT, (int)GridColumnGroupLCA.getHeight(group));
        WidgetLCAUtil.preserveProperty((Widget)group, (String)PROP_VISIBLE, (boolean)GridColumnGroupLCA.isVisible(group));
        WidgetLCAUtil.preserveProperty((Widget)group, (String)PROP_FONT, (Object)group.getHeaderFont());
        WidgetLCAUtil.preserveProperty((Widget)group, (String)PROP_EXPANDED, (boolean)group.getExpanded());
        WidgetLCAUtil.preserveProperty((Widget)group, (String)PROP_HEADER_WORD_WRAP, (boolean)group.getHeaderWordWrap());
        WidgetLCAUtil.preserveProperty((Widget)group, (String)PROP_FIXED, (boolean)GridColumnGroupLCA.isFixed(group));
    }

    public void renderChanges(GridColumnGroup group) throws IOException {
        WidgetLCAUtil.renderCustomVariant((Widget)group);
        ItemLCAUtil.renderChanges((Item)group);
        WidgetLCAUtil.renderProperty((Widget)group, (String)PROP_LEFT, (int)GridColumnGroupLCA.getLeft(group), (int)0);
        WidgetLCAUtil.renderProperty((Widget)group, (String)PROP_WIDTH, (int)GridColumnGroupLCA.getWidth(group), (int)0);
        WidgetLCAUtil.renderProperty((Widget)group, (String)PROP_HEIGHT, (int)GridColumnGroupLCA.getHeight(group), (int)0);
        WidgetLCAUtil.renderProperty((Widget)group, (String)PROP_VISIBLE, (boolean)GridColumnGroupLCA.isVisible(group), (boolean)true);
        GridColumnGroupLCA.renderFont(group, PROP_FONT, group.getHeaderFont());
        WidgetLCAUtil.renderProperty((Widget)group, (String)PROP_EXPANDED, (boolean)group.getExpanded(), (boolean)true);
        WidgetLCAUtil.renderProperty((Widget)group, (String)PROP_HEADER_WORD_WRAP, (boolean)group.getHeaderWordWrap(), (boolean)false);
        WidgetLCAUtil.renderProperty((Widget)group, (String)PROP_FIXED, (boolean)GridColumnGroupLCA.isFixed(group), (boolean)false);
    }

    private static void renderFont(GridColumnGroup group, String property, Font newValue) {
        if (WidgetLCAUtil.hasChanged((Widget)group, (String)property, (Object)newValue, (Object)group.getParent().getFont())) {
            RemoteObjectFactory.getRemoteObject((Widget)group).set(property, JsonMapping.toJson((Font)newValue));
        }
    }

    private static int getLeft(GridColumnGroup group) {
        int result = 0;
        Grid grid = group.getParent();
        int[] columnOrder = grid.getColumnOrder();
        boolean found = false;
        int i = 0;
        while (i < columnOrder.length && !found) {
            GridColumn currentColumn = grid.getColumn(columnOrder[i]);
            if (currentColumn.getColumnGroup() == group) {
                found = true;
            } else if (currentColumn.isVisible()) {
                result += currentColumn.getWidth();
            }
            ++i;
        }
        return result;
    }

    private static int getWidth(GridColumnGroup group) {
        int result = 0;
        GridColumn[] columns = group.getColumns();
        int i = 0;
        while (i < columns.length) {
            if (columns[i].isVisible()) {
                result += columns[i].getWidth();
            }
            ++i;
        }
        return result;
    }

    private static int getHeight(GridColumnGroup group) {
        return group.getParent().getGroupHeaderHeight();
    }

    private static boolean isVisible(GridColumnGroup group) {
        boolean result = false;
        GridColumn[] columns = group.getColumns();
        int i = 0;
        while (i < columns.length && !result) {
            if (columns[i].isVisible()) {
                result = true;
            }
            ++i;
        }
        return result;
    }

    private static boolean isFixed(GridColumnGroup group) {
        boolean result = false;
        IGridAdapter gridAdapter = GridColumnGroupLCA.getGridAdapter(group);
        GridColumn[] gridColumnArray = group.getColumns();
        int n = gridColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            GridColumn column = gridColumnArray[n2];
            if (gridAdapter.isFixedColumn(column)) {
                result = true;
            }
            ++n2;
        }
        return result;
    }

    private static IGridAdapter getGridAdapter(GridColumnGroup group) {
        return group.getParent().getAdapter(IGridAdapter.class);
    }
}

