/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDDerivationMethod;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFacet;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDIdentityConstraintDefinition;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDNotationDeclaration;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDRedefine;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTerm;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDWildcard;
import org.eclipse.xsd.XSDXPathDefinition;
import org.eclipse.xsd.util.XSDResourceFactoryImpl;
import org.w3c.dom.Element;

public abstract class XSDSchemaBuildingTools {
    protected static XSDPackage m_xsdPackage = null;
    protected static XSDFactory m_xsdFactory = null;

    public static XSDSimpleTypeDefinition addSimpleTypeDefinition(XSDSchema schema, String localName, String type, String userInfo) {
        if (schema == null || localName == null || type == null) {
            throw new IllegalArgumentException("addSimpleTypeDefinition called with null schema/type/name");
        }
        XSDFactory xsdFactory = XSDFactory.eINSTANCE;
        XSDSimpleTypeDefinition simpleType = xsdFactory.createXSDSimpleTypeDefinition();
        simpleType.setName(localName);
        simpleType.setBaseTypeDefinition(schema.resolveSimpleTypeDefinition(type));
        schema.getContents().add((Object)simpleType);
        if (userInfo != null) {
            XSDSchemaBuildingTools.addUserInformation(simpleType, null, userInfo);
        }
        return simpleType;
    }

    public static XSDComplexTypeDefinition addComplexTypeDefinition(XSDSchema schema, String localName, String type, HashMap attrs, String userInfo) {
        if (schema == null || localName == null || type == null) {
            throw new IllegalArgumentException("addComplexTypeDefinition called with null schema/type/name");
        }
        XSDFactory xsdFactory = XSDFactory.eINSTANCE;
        XSDComplexTypeDefinition complexType = xsdFactory.createXSDComplexTypeDefinition();
        complexType.setName(localName);
        complexType.setDerivationMethod(XSDDerivationMethod.EXTENSION_LITERAL);
        schema.getContents().add((Object)complexType);
        XSDSimpleTypeDefinition anonSimpleType = xsdFactory.createXSDSimpleTypeDefinition();
        complexType.setBaseTypeDefinition(schema.resolveSimpleTypeDefinition(type));
        complexType.setContent(anonSimpleType);
        if (attrs != null) {
            Iterator iter = attrs.keySet().iterator();
            while (iter.hasNext()) {
                String attrName = (String)iter.next();
                Object attrType = attrs.get(attrName);
                XSDSchemaBuildingTools.addAttributeDeclaration(complexType, attrName, attrType);
            }
        }
        if (userInfo != null) {
            XSDSchemaBuildingTools.addUserInformation(complexType, null, userInfo);
        }
        return complexType;
    }

    public static XSDAttributeDeclaration addAttributeDeclaration(XSDConcreteComponent component, String localName, Object type) {
        if (component == null || localName == null || type == null) {
            throw new IllegalArgumentException("addAttributeDeclaration called with null component/type/name");
        }
        XSDFactory xsdFactory = XSDFactory.eINSTANCE;
        XSDAttributeDeclaration attrDecl = xsdFactory.createXSDAttributeDeclaration();
        attrDecl.setName(localName);
        if (type instanceof XSDAttributeDeclaration) {
            attrDecl.setResolvedAttributeDeclaration((XSDAttributeDeclaration)type);
        } else if (type instanceof String) {
            attrDecl.setTypeDefinition(component.getSchema().resolveSimpleTypeDefinition((String)type));
        } else {
            throw new IllegalArgumentException("addAttributeDeclaration illegal type, is: " + type);
        }
        if (component instanceof XSDSchema) {
            ((XSDSchema)component).getContents().add((Object)attrDecl);
        } else if (component instanceof XSDComplexTypeDefinition) {
            XSDAttributeUse attrUse = xsdFactory.createXSDAttributeUse();
            attrUse.setContent(attrDecl);
            ((XSDComplexTypeDefinition)component).getAttributeContents().add((Object)attrUse);
        } else {
            throw new IllegalArgumentException("Unable to addAttributeDeclaration to type: " + component);
        }
        return attrDecl;
    }

    public static XSDAnnotation addUserInformation(XSDConcreteComponent component, String sourceURI, String text) {
        if (component == null || text == null) {
            throw new IllegalArgumentException("addUserInformation called with null component or text");
        }
        try {
            XSDFactory xsdFactory = XSDFactory.eINSTANCE;
            XSDAnnotation xsdAnnotation = xsdFactory.createXSDAnnotation();
            if (component instanceof XSDAttributeDeclaration) {
                ((XSDAttributeDeclaration)component).setAnnotation(xsdAnnotation);
            } else if (component instanceof XSDAttributeGroupDefinition) {
                ((XSDAttributeGroupDefinition)component).setAnnotation(xsdAnnotation);
            } else if (component instanceof XSDElementDeclaration) {
                ((XSDElementDeclaration)component).setAnnotation(xsdAnnotation);
            } else if (component instanceof XSDFacet) {
                ((XSDFacet)component).setAnnotation(xsdAnnotation);
            } else if (component instanceof XSDIdentityConstraintDefinition) {
                ((XSDIdentityConstraintDefinition)component).setAnnotation(xsdAnnotation);
            } else if (component instanceof XSDImport) {
                ((XSDImport)component).setAnnotation(xsdAnnotation);
            } else if (component instanceof XSDInclude) {
                ((XSDInclude)component).setAnnotation(xsdAnnotation);
            } else if (component instanceof XSDModelGroup) {
                ((XSDModelGroup)component).setAnnotation(xsdAnnotation);
            } else if (component instanceof XSDModelGroupDefinition) {
                ((XSDModelGroupDefinition)component).setAnnotation(xsdAnnotation);
            } else if (component instanceof XSDNotationDeclaration) {
                ((XSDNotationDeclaration)component).setAnnotation(xsdAnnotation);
            } else if (component instanceof XSDTypeDefinition) {
                ((XSDTypeDefinition)component).setAnnotation(xsdAnnotation);
            } else if (component instanceof XSDWildcard) {
                ((XSDWildcard)component).setAnnotation(xsdAnnotation);
            } else if (component instanceof XSDXPathDefinition) {
                ((XSDXPathDefinition)component).setAnnotation(xsdAnnotation);
            } else if (component instanceof XSDSchema) {
                ((XSDSchema)component).getContents().add((Object)xsdAnnotation);
            } else {
                throw new IllegalArgumentException("Unable to addUserInformation onto type: " + component);
            }
            Element userInfo = xsdAnnotation.createUserInformation(sourceURI);
            userInfo.appendChild(userInfo.getOwnerDocument().createTextNode(text));
            xsdAnnotation.getElement().appendChild(userInfo);
            return xsdAnnotation;
        }
        catch (Exception e) {
            System.err.println("addUserInformation threw an Exception:");
            e.printStackTrace();
            return null;
        }
    }

    public static XSDModelGroup addModelGroupDefinition(XSDConcreteComponent component, String localName, XSDCompositor compositor, List groupTerms) {
        if (component == null || localName == null || groupTerms == null) {
            throw new IllegalArgumentException("addModelGroupDefinition called with null component/name/list");
        }
        XSDFactory xsdFactory = XSDFactory.eINSTANCE;
        XSDModelGroup modelGroup = xsdFactory.createXSDModelGroup();
        modelGroup.setCompositor(compositor);
        Iterator terms = groupTerms.iterator();
        while (terms.hasNext()) {
            Object tmp = terms.next();
            try {
                XSDTerm termItem = (XSDTerm)tmp;
                XSDParticle termParticle = xsdFactory.createXSDParticle();
                termParticle.setContent(termItem);
                modelGroup.getContents().add((Object)termParticle);
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("addModelGroupDefinition illegal list type: " + tmp);
            }
        }
        if (component instanceof XSDComplexTypeDefinition) {
            XSDParticle modelGroupParticle = xsdFactory.createXSDParticle();
            modelGroupParticle.setContent(modelGroup);
            ((XSDComplexTypeDefinition)component).setContent(modelGroupParticle);
        } else if (component instanceof XSDSchema) {
            XSDModelGroupDefinition modelGroupDef = xsdFactory.createXSDModelGroupDefinition();
            modelGroupDef.setName(localName);
            modelGroupDef.setModelGroup(modelGroup);
            ((XSDSchema)component).getContents().add((Object)modelGroupDef);
        } else {
            throw new IllegalArgumentException("addModelGroupDefinition doesn't know how to add it to component: " + component);
        }
        return modelGroup;
    }

    public static boolean removeTypeDefinition(XSDSchema schema, String namespace, String localName) {
        if (schema == null || localName == null) {
            throw new IllegalArgumentException("removeTypeDefinition called with null schema/localName");
        }
        XSDTypeDefinition typeDefinition = schema.resolveTypeDefinition(namespace, localName);
        XSDConcreteComponent container = typeDefinition.getContainer();
        if (container == null) {
            return false;
        }
        if (container instanceof XSDSchema) {
            return ((XSDSchema)container).getContents().remove((Object)typeDefinition);
        }
        if (container instanceof XSDRedefine) {
            return ((XSDRedefine)container).getContents().remove((Object)typeDefinition);
        }
        return false;
    }

    public static XSDSchema getBlankSchema(XSDFactory factory, String targetPrefix, String targetNS, String annotationText, String annotationSource) {
        if (factory == null) {
            factory = XSDSchemaBuildingTools.getXSDFactory();
        }
        XSDSchema schema = factory.createXSDSchema();
        schema.setTargetNamespace(targetNS);
        schema.setSchemaForSchemaQNamePrefix("xsd");
        Map namespaces = schema.getQNamePrefixToNamespaceMap();
        namespaces.put(targetPrefix, schema.getTargetNamespace());
        namespaces.put(schema.getSchemaForSchemaQNamePrefix(), "http://www.w3.org/2001/XMLSchema");
        if (annotationText != null) {
            XSDSchemaBuildingTools.addUserInformation(schema, annotationSource, annotationText);
        }
        return schema;
    }

    public static XSDFactory getXSDFactory() {
        if (m_xsdFactory != null) {
            return m_xsdFactory;
        }
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("xsd", new XSDResourceFactoryImpl());
        m_xsdPackage = XSDPackage.eINSTANCE;
        m_xsdFactory = XSDFactory.eINSTANCE;
        return m_xsdFactory;
    }
}

