/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.Secret;
import org.mandas.docker.client.messages.swarm.SecretSpec;
import org.mandas.docker.client.messages.swarm.Version;

final class ImmutableSecret
implements Secret {
    private final String id;
    private final Version version;
    private final Date createdAt;
    private final Date updatedAt;
    private final SecretSpec secretSpec;

    private ImmutableSecret(String id, Version version, Date createdAt, Date updatedAt, SecretSpec secretSpec) {
        this.id = id;
        this.version = version;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.secretSpec = secretSpec;
    }

    @Override
    @JsonProperty(value="ID")
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="Version")
    public Version version() {
        return this.version;
    }

    @Override
    @JsonProperty(value="CreatedAt")
    public Date createdAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="UpdatedAt")
    public Date updatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty(value="Spec")
    public SecretSpec secretSpec() {
        return this.secretSpec;
    }

    public final ImmutableSecret withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableSecret(newValue, this.version, this.createdAt, this.updatedAt, this.secretSpec);
    }

    public final ImmutableSecret withVersion(Version value) {
        if (this.version == value) {
            return this;
        }
        Version newValue = Objects.requireNonNull(value, "version");
        return new ImmutableSecret(this.id, newValue, this.createdAt, this.updatedAt, this.secretSpec);
    }

    public final ImmutableSecret withCreatedAt(Date value) {
        if (this.createdAt == value) {
            return this;
        }
        Date newValue = Objects.requireNonNull(value, "createdAt");
        return new ImmutableSecret(this.id, this.version, newValue, this.updatedAt, this.secretSpec);
    }

    public final ImmutableSecret withUpdatedAt(Date value) {
        if (this.updatedAt == value) {
            return this;
        }
        Date newValue = Objects.requireNonNull(value, "updatedAt");
        return new ImmutableSecret(this.id, this.version, this.createdAt, newValue, this.secretSpec);
    }

    public final ImmutableSecret withSecretSpec(SecretSpec value) {
        if (this.secretSpec == value) {
            return this;
        }
        SecretSpec newValue = Objects.requireNonNull(value, "secretSpec");
        return new ImmutableSecret(this.id, this.version, this.createdAt, this.updatedAt, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSecret && this.equalTo(0, (ImmutableSecret)another);
    }

    private boolean equalTo(int synthetic, ImmutableSecret another) {
        return this.id.equals(another.id) && this.version.equals(another.version) && this.createdAt.equals(another.createdAt) && this.updatedAt.equals(another.updatedAt) && this.secretSpec.equals(another.secretSpec);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.version.hashCode();
        h += (h << 5) + this.createdAt.hashCode();
        h += (h << 5) + this.updatedAt.hashCode();
        h += (h << 5) + this.secretSpec.hashCode();
        return h;
    }

    public String toString() {
        return "Secret{id=" + this.id + ", version=" + String.valueOf(this.version) + ", createdAt=" + String.valueOf(this.createdAt) + ", updatedAt=" + String.valueOf(this.updatedAt) + ", secretSpec=" + String.valueOf(this.secretSpec) + "}";
    }

    public static ImmutableSecret copyOf(Secret instance) {
        if (instance instanceof ImmutableSecret) {
            return (ImmutableSecret)instance;
        }
        return ImmutableSecret.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_VERSION = 2L;
        private static final long INIT_BIT_CREATED_AT = 4L;
        private static final long INIT_BIT_UPDATED_AT = 8L;
        private static final long INIT_BIT_SECRET_SPEC = 16L;
        private long initBits = 31L;
        private String id;
        private Version version;
        private Date createdAt;
        private Date updatedAt;
        private SecretSpec secretSpec;

        private Builder() {
        }

        public final Builder from(Secret instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.version(instance.version());
            this.createdAt(instance.createdAt());
            this.updatedAt(instance.updatedAt());
            this.secretSpec(instance.secretSpec());
            return this;
        }

        @JsonProperty(value="ID")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Version")
        public final Builder version(Version version) {
            this.version = Objects.requireNonNull(version, "version");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="CreatedAt")
        public final Builder createdAt(Date createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="UpdatedAt")
        public final Builder updatedAt(Date updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="Spec")
        public final Builder secretSpec(SecretSpec secretSpec) {
            this.secretSpec = Objects.requireNonNull(secretSpec, "secretSpec");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableSecret build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSecret(this.id, this.version, this.createdAt, this.updatedAt, this.secretSpec);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("version");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("createdAt");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("updatedAt");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("secretSpec");
            }
            return "Cannot build Secret, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    static final class Criteria
    implements Secret.Criteria {
        @Nullable
        private final String id;
        @Nullable
        private final String label;
        @Nullable
        private final String name;

        private Criteria(@Nullable String id, @Nullable String label, @Nullable String name) {
            this.id = id;
            this.label = label;
            this.name = name;
        }

        @Override
        @Nullable
        public String id() {
            return this.id;
        }

        @Override
        @Nullable
        public String label() {
            return this.label;
        }

        @Override
        @Nullable
        public String name() {
            return this.name;
        }

        public final Criteria withId(@Nullable String value) {
            if (Objects.equals(this.id, value)) {
                return this;
            }
            return new Criteria(value, this.label, this.name);
        }

        public final Criteria withLabel(@Nullable String value) {
            if (Objects.equals(this.label, value)) {
                return this;
            }
            return new Criteria(this.id, value, this.name);
        }

        public final Criteria withName(@Nullable String value) {
            if (Objects.equals(this.name, value)) {
                return this;
            }
            return new Criteria(this.id, this.label, value);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Criteria && this.equalTo(0, (Criteria)another);
        }

        private boolean equalTo(int synthetic, Criteria another) {
            return Objects.equals(this.id, another.id) && Objects.equals(this.label, another.label) && Objects.equals(this.name, another.name);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Objects.hashCode(this.id);
            h += (h << 5) + Objects.hashCode(this.label);
            h += (h << 5) + Objects.hashCode(this.name);
            return h;
        }

        public String toString() {
            return "Criteria{id=" + this.id + ", label=" + this.label + ", name=" + this.name + "}";
        }

        public static Criteria copyOf(Secret.Criteria instance) {
            if (instance instanceof Criteria) {
                return (Criteria)instance;
            }
            return Criteria.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        static final class Builder
        implements Secret.Criteria.Builder {
            private String id;
            private String label;
            private String name;

            private Builder() {
            }

            public final Builder from(Secret.Criteria instance) {
                String nameValue;
                String labelValue;
                Objects.requireNonNull(instance, "instance");
                String idValue = instance.id();
                if (idValue != null) {
                    this.id(idValue);
                }
                if ((labelValue = instance.label()) != null) {
                    this.label(labelValue);
                }
                if ((nameValue = instance.name()) != null) {
                    this.name(nameValue);
                }
                return this;
            }

            @Override
            public final Builder id(@Nullable String id) {
                this.id = id;
                return this;
            }

            @Override
            public final Builder label(@Nullable String label) {
                this.label = label;
                return this;
            }

            @Override
            public final Builder name(@Nullable String name) {
                this.name = name;
                return this;
            }

            @Override
            public Criteria build() {
                return new Criteria(this.id, this.label, this.name);
            }
        }
    }
}

