/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gprof.symbolManager;

import java.util.LinkedList;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.linuxtools.internal.gprof.symbolManager.CallGraphArc;

public class CallGraphNode {
    private final IBinaryParser.ISymbol symbol;
    private final LinkedList<CallGraphArc> parents = new LinkedList();
    private final LinkedList<CallGraphArc> children = new LinkedList();

    public CallGraphNode(IBinaryParser.ISymbol symbol) {
        this.symbol = symbol;
    }

    public CallGraphArc getInputArc(CallGraphNode parent) {
        for (CallGraphArc inputArc : this.parents) {
            if (inputArc.parent != parent) continue;
            return inputArc;
        }
        return null;
    }

    public CallGraphArc getOutputArc(CallGraphNode child) {
        for (CallGraphArc outputArc : this.children) {
            if (outputArc.child != child) continue;
            return outputArc;
        }
        return null;
    }

    public IBinaryParser.ISymbol getSymbol() {
        return this.symbol;
    }

    public LinkedList<CallGraphArc> getParents() {
        return this.parents;
    }

    public LinkedList<CallGraphArc> getChildren() {
        return this.children;
    }

    public void print() {
        System.out.println(this.symbol.getName());
        System.out.println(" -- parents --");
        for (CallGraphArc arc : this.parents) {
            arc.print();
        }
        System.out.println(" -- children --");
        for (CallGraphArc arc : this.children) {
            arc.print();
        }
    }

    public int getCalls() {
        int ret = 0;
        for (CallGraphArc arc : this.parents) {
            ret += arc.getCount();
        }
        return ret;
    }
}

