/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.nekohtml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

class SecuritySupport {
    private static final SecuritySupport securitySupport = new SecuritySupport();

    SecuritySupport() {
    }

    static SecuritySupport getInstance() {
        return securitySupport;
    }

    ClassLoader getContextClassLoader() {
        PrivilegedAction<ClassLoader> action = () -> {
            ClassLoader cl = null;
            try {
                cl = Thread.currentThread().getContextClassLoader();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            return cl;
        };
        return AccessController.doPrivileged(action);
    }

    ClassLoader getSystemClassLoader() {
        PrivilegedAction<ClassLoader> action = () -> {
            ClassLoader cl = null;
            try {
                cl = ClassLoader.getSystemClassLoader();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            return cl;
        };
        return AccessController.doPrivileged(action);
    }

    ClassLoader getParentClassLoader(ClassLoader cl) {
        PrivilegedAction<ClassLoader> action = () -> {
            ClassLoader parent = null;
            try {
                parent = cl.getParent();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            return parent == cl ? null : parent;
        };
        return AccessController.doPrivileged(action);
    }

    String getSystemProperty(String propName) {
        PrivilegedAction<String> action = () -> System.getProperty(propName);
        return AccessController.doPrivileged(action);
    }

    FileInputStream getFileInputStream(File file) throws FileNotFoundException {
        try {
            PrivilegedExceptionAction<FileInputStream> action = () -> new FileInputStream(file);
            return AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException e) {
            throw (FileNotFoundException)e.getException();
        }
    }

    InputStream getResourceAsStream(ClassLoader cl, String name) {
        PrivilegedAction<InputStream> action = () -> {
            InputStream ris = cl == null ? ClassLoader.getSystemResourceAsStream(name) : cl.getResourceAsStream(name);
            return ris;
        };
        return AccessController.doPrivileged(action);
    }

    boolean getFileExists(File f) {
        PrivilegedAction<Boolean> action = f::exists;
        return AccessController.doPrivileged(action);
    }

    long getLastModified(File f) {
        PrivilegedAction<Long> action = f::lastModified;
        return AccessController.doPrivileged(action);
    }
}

