/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.perf.launch;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.internal.perf.PerfCore;
import org.eclipse.linuxtools.internal.perf.PerfPlugin;
import org.eclipse.linuxtools.internal.perf.SourceDisassemblyData;
import org.eclipse.linuxtools.internal.perf.StatData;
import org.eclipse.linuxtools.internal.perf.launch.Messages;
import org.eclipse.linuxtools.internal.perf.ui.SourceDisassemblyView;
import org.eclipse.linuxtools.internal.perf.ui.StatView;
import org.eclipse.linuxtools.profiling.launch.ConfigUtils;
import org.eclipse.linuxtools.profiling.launch.IRemoteCommandLauncher;
import org.eclipse.linuxtools.profiling.launch.IRemoteFileProxy;
import org.eclipse.linuxtools.profiling.launch.RemoteConnection;
import org.eclipse.linuxtools.profiling.launch.RemoteConnectionException;
import org.eclipse.linuxtools.profiling.launch.RemoteProxyManager;
import org.eclipse.linuxtools.tools.launch.core.factory.RuntimeProcessFactory;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class PerfLaunchConfigDelegate
extends AbstractCLaunchDelegate {
    private static final String OUTPUT_STR = "--output=";
    private static final String EMPTY_STRING = "";
    private IPath binPath;
    private IPath workingDirPath;
    private IProject project;

    protected String getPluginID() {
        return "org.eclipse.linuxtools.perf";
    }

    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        block28: {
            try {
                Process pProxy;
                ConfigUtils configUtils = new ConfigUtils(config);
                this.project = configUtils.getProject();
                PerfPlugin.getDefault().setProfiledProject(this.project);
                if (!PerfCore.checkPerfInPath(this.project)) {
                    IStatus status = Status.error((String)"Error: Perf was not found on PATH");
                    throw new CoreException(status);
                }
                URI workingDirURI = new URI(config.getAttribute("REMOTE_WORKING_DIRECTORY_NAME", EMPTY_STRING));
                boolean isLocalProject = false;
                if (workingDirURI.toString().equals(EMPTY_STRING)) {
                    isLocalProject = true;
                    workingDirURI = this.getWorkingDirectory(config).toURI();
                    this.binPath = CDebugUtils.verifyProgramPath((ILaunchConfiguration)config);
                } else {
                    URI binURI = new URI(configUtils.getExecutablePath());
                    this.binPath = Path.fromPortableString((String)binURI.getPath().toString());
                }
                this.workingDirPath = Path.fromPortableString((String)(workingDirURI.getPath() + "/"));
                PerfPlugin.getDefault().setWorkingDir(this.workingDirPath);
                if (config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.ShowStat", false)) {
                    this.showStat(config, launch);
                    break block28;
                }
                String perfPathString = RuntimeProcessFactory.getFactory().whichCommand("perf", this.project);
                RemoteConnection workingDirRC = new RemoteConnection(workingDirURI);
                IRemoteFileProxy workingDirRFP = workingDirRC.getRmtFileProxy();
                if (!isLocalProject) {
                    perfPathString = RuntimeProcessFactory.getFactory().whichCommand("perf", null);
                    if (config.getAttribute("ENABLE_COPY_FROM_EXE", false)) {
                        URI localBinURI = URI.create(config.getAttribute("COPY_FROM_EXE_NAME", EMPTY_STRING));
                        IFileStore localBin = EFS.getLocalFileSystem().getStore(localBinURI);
                        IFileStore remoteBin = workingDirRFP.getResource(this.binPath.lastSegment());
                        localBin.copy(remoteBin, 6, (IProgressMonitor)new NullProgressMonitor());
                    }
                }
                String[] arguments = this.getProgramArgumentsArray(config);
                ArrayList<String> command = new ArrayList<String>(4 + arguments.length);
                command.addAll(Arrays.asList(PerfCore.getRecordString(config)));
                command.add(this.binPath.toPortableString());
                command.set(0, perfPathString);
                command.add(2, "--output=perf.data");
                command.addAll(Arrays.asList(arguments));
                String[] commandArray = command.toArray(new String[command.size()]);
                if (isLocalProject) {
                    IFileStore workingDir = workingDirRFP.getResource(workingDirURI.getPath());
                    pProxy = RuntimeProcessFactory.getFactory().exec(commandArray, this.getEnvironment(config), workingDir, this.project);
                } else {
                    String[] commandArgs = command.subList(1, command.size()).toArray(new String[command.size() - 1]);
                    IRemoteCommandLauncher launcher = RemoteProxyManager.getInstance().getLauncher(workingDirURI);
                    pProxy = launcher.execute((IPath)new Path(perfPathString), commandArgs, this.getEnvironment(config), this.workingDirPath, (IProgressMonitor)new NullProgressMonitor());
                }
                MessageConsole console = new MessageConsole("Perf Console", null);
                console.activate();
                ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{console});
                MessageConsoleStream stream = console.newMessageStream();
                if (pProxy != null) {
                    try (BufferedReader error = new BufferedReader(new InputStreamReader(pProxy.getErrorStream()));){
                        String err = error.readLine();
                        while (err != null) {
                            stream.println(err);
                            err = error.readLine();
                        }
                    }
                }
                pProxy.destroy();
                if (!isLocalProject) {
                    IFileStore remotePerfData = workingDirRFP.getResource(this.workingDirPath.append("perf.data").toString());
                    URI localPerfDataURI = URI.create(this.getWorkingDirectory(config).toString() + "/perf.data");
                    IFileStore localPerfData = EFS.getLocalFileSystem().getStore(localPerfDataURI);
                    remotePerfData.copy(localPerfData, 6, (IProgressMonitor)new NullProgressMonitor());
                }
                PrintStream print = null;
                if (config.getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_OUTPUT_ON", true)) {
                    ConsolePlugin plugin = ConsolePlugin.getDefault();
                    IConsoleManager conMan = plugin.getConsoleManager();
                    IConsole[] existing = conMan.getConsoles();
                    IOConsole binaryOutCons = null;
                    for (IConsole x : existing) {
                        if (!x.getName().contains(this.renderProcessLabel(commandArray[0]))) continue;
                        binaryOutCons = (IOConsole)x;
                    }
                    if (binaryOutCons == null && existing.length != 0 && existing[existing.length - 1] instanceof IOConsole) {
                        binaryOutCons = (IOConsole)existing[existing.length - 1];
                    }
                    if (binaryOutCons != null) {
                        IOConsoleOutputStream outputTo = binaryOutCons.newOutputStream();
                        print = new PrintStream((OutputStream)outputTo);
                    }
                    for (int i = 0; i < command.size(); ++i) {
                        print.print((String)command.get(i) + " ");
                    }
                    print.println();
                    print.println("Analysing recorded perf.data, please wait...");
                }
                if (isLocalProject) {
                    PerfCore.report(config, this.workingDirPath, monitor, null, print);
                } else {
                    Path localPerfDataDir = new Path(this.getWorkingDirectory(config).toString() + String.valueOf('/'));
                    PerfCore.report(config, (IPath)localPerfDataDir, monitor, null, print);
                }
                URI perfDataURI = null;
                IRemoteFileProxy proxy = null;
                perfDataURI = new URI(workingDirURI.toString() + "/perf.data");
                proxy = RemoteProxyManager.getInstance().getFileProxy(perfDataURI);
                IFileStore perfDataFileStore = proxy.getResource(perfDataURI.getPath());
                IFileInfo info = perfDataFileStore.fetchInfo();
                info.setAttribute(2, true);
                perfDataFileStore.putInfo(info, 1024, null);
                PerfCore.refreshView(this.renderProcessLabel(this.binPath.toPortableString()));
                if (config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.ShowSourceDisassembly", false)) {
                    this.showSourceDisassembly(Path.fromPortableString((String)(workingDirURI.toString() + "/")));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                this.abort(e.getLocalizedMessage(), null, 150);
            }
            catch (RemoteConnectionException e) {
                e.printStackTrace();
                this.abort(e.getLocalizedMessage(), null, 150);
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                this.abort(e.getLocalizedMessage(), null, 150);
            }
        }
    }

    private void showSourceDisassembly(IPath workingDir) {
        String title = this.renderProcessLabel(workingDir.toPortableString() + "perf.data");
        SourceDisassemblyData sdData = new SourceDisassemblyData(title, workingDir, this.project);
        sdData.parse();
        PerfPlugin.getDefault().setSourceDisassemblyData(sdData);
        SourceDisassemblyView.refreshView();
    }

    private void showStat(ILaunchConfiguration config, ILaunch launch) throws CoreException {
        String[] arguments = this.getProgramArgumentsArray(config);
        int runCount = config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.StatRunCount", 1);
        StringBuilder args = new StringBuilder();
        for (String arg : arguments) {
            args.append(arg);
            args.append(" ");
        }
        URI binURI = null;
        try {
            binURI = new URI(this.binPath.toPortableString());
        }
        catch (URISyntaxException e) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.MsgProxyError, (String)Messages.MsgProxyError);
        }
        String title = this.renderProcessLabel(MessageFormat.format(Messages.PerfLaunchConfigDelegate_stat_title, binURI.getPath(), args.toString(), String.valueOf(runCount)));
        List configEvents = config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.SelectedEvents", PerfPlugin.ATTR_SelectedEvents_default);
        String[] statEvents = new String[]{};
        if (!config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.DefaultEvent", true)) {
            statEvents = configEvents == null ? statEvents : configEvents.toArray(new String[0]);
        }
        StatData sd = new StatData(title, this.workingDirPath, binURI.getPath(), arguments, runCount, statEvents, this.project);
        sd.setLaunch(launch);
        sd.parse();
        PerfPlugin.getDefault().setStatData(sd);
        sd.updateStatData();
        StatView.refreshView();
    }
}

