/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.callgraph.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.callgraph.core.CallgraphCorePlugin;
import org.eclipse.linuxtools.internal.callgraph.core.Messages;
import org.eclipse.linuxtools.internal.callgraph.core.PluginConstants;

public class SystemTapErrorHandler {
    public static final String FILE_PROP = "errors.prop";
    private final int LINE_LIMIT = 300;
    private boolean errorRecognized = false;
    private StringBuilder errorMessage = new StringBuilder("");
    private StringBuilder logContents;

    public SystemTapErrorHandler() {
        this.errorMessage.append(Messages.getString("SystemTapErrorHandler.ErrorMessage") + Messages.getString("SystemTapErrorHandler.ErrorMessage1"));
        this.logContents = new StringBuilder();
    }

    public void handle(IProgressMonitor m, String errors) {
        String[] errorsList = errors.split("\n");
        File file = new File(PluginConstants.getPluginLocation() + FILE_PROP);
        try (BufferedReader buff1 = new BufferedReader(new FileReader(file));){
            block14: for (String message : errorsList) {
                try (BufferedReader innerBuff = new BufferedReader(new FileReader(file));){
                    String line;
                    while ((line = innerBuff.readLine()) != null) {
                        if (m != null && m.isCanceled()) {
                            return;
                        }
                        int index = line.indexOf(61);
                        Pattern pat = Pattern.compile(line.substring(0, index), 32);
                        Matcher matcher = pat.matcher(message);
                        if (!matcher.matches()) continue;
                        if (!this.isErrorRecognized()) {
                            this.errorMessage.append(Messages.getString("SystemTapErrorHandler.ErrorMessage2"));
                            this.errorRecognized = true;
                        }
                        String errorFound = line.substring(index + 1);
                        if (this.errorMessage.toString().contains(errorFound)) continue block14;
                        this.errorMessage.append(errorFound + "\n");
                        continue block14;
                    }
                }
            }
            this.logContents.append(errors);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void appendToLog(String header) {
        this.logContents.append(header);
    }

    public void handle(IProgressMonitor m, FileReader f) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(f);
        StringBuilder builder = new StringBuilder();
        int counter = 0;
        while ((line = br.readLine()) != null) {
            ++counter;
            builder.append(line + "\n");
            if (m != null && m.isCanceled()) {
                return;
            }
            if (counter != 300) continue;
            this.handle(m, builder.toString());
            builder = new StringBuilder();
            counter = 0;
        }
        this.handle(m, builder.toString());
    }

    public void finishHandling() {
        if (!this.isErrorRecognized()) {
            this.errorMessage.append(Messages.getString("SystemTapErrorHandler.NoErrRecognized") + Messages.getString("SystemTapErrorHandler.NoErrRecognizedMsg"));
            this.writeToLog();
        }
    }

    private void writeToLog() {
        CallgraphCorePlugin.getDefault().getLog().log(Status.info((String)this.logContents.toString()));
        this.logContents = new StringBuilder();
    }

    public boolean isErrorRecognized() {
        return this.errorRecognized;
    }

    public String getErrorMessage() {
        return this.errorMessage.toString();
    }
}

