/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.transaction;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.keyple.seproxy.ChannelState;
import org.eclipse.keyple.seproxy.SeSelector;
import org.eclipse.keyple.seproxy.message.ApduRequest;
import org.eclipse.keyple.seproxy.message.SeRequest;
import org.eclipse.keyple.seproxy.protocol.SeProtocol;
import org.eclipse.keyple.transaction.MatchingSe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeSelectionRequest {
    private static final Logger logger = LoggerFactory.getLogger(SeSelectionRequest.class);
    private SeSelector seSelector;
    private Class<? extends MatchingSe> matchingClass = MatchingSe.class;
    private Class<? extends SeSelectionRequest> selectionClass = SeSelectionRequest.class;
    private final List<ApduRequest> seSelectionApduRequestList = new ArrayList<ApduRequest>();
    protected final ChannelState channelState;
    protected final SeProtocol protocolFlag;

    public SeSelectionRequest(SeSelector seSelector, ChannelState channelState, SeProtocol protocolFlag) {
        this.seSelector = seSelector;
        this.channelState = channelState;
        this.protocolFlag = protocolFlag;
        if (logger.isTraceEnabled()) {
            logger.trace("SeSelection");
        }
    }

    protected final SeRequest getSelectionRequest() {
        SeRequest seSelectionRequest = null;
        seSelectionRequest = new SeRequest(this.seSelector, this.seSelectionApduRequestList, this.channelState, this.protocolFlag);
        return seSelectionRequest;
    }

    public SeSelector getSeSelector() {
        return this.seSelector;
    }

    protected final void setMatchingClass(Class<? extends MatchingSe> matchingClass) {
        this.matchingClass = matchingClass;
    }

    protected final void setSelectionClass(Class<? extends SeSelectionRequest> selectionClass) {
        this.selectionClass = selectionClass;
    }

    protected final Class<? extends SeSelectionRequest> getSelectionClass() {
        return this.selectionClass;
    }

    protected final Class<? extends MatchingSe> getMatchingClass() {
        return this.matchingClass;
    }

    protected final void addApduRequest(ApduRequest apduRequest) {
        this.seSelectionApduRequestList.add(apduRequest);
    }

    public String toString() {
        return "SeSelectionRequest: SELECTION_CLASS = " + this.selectionClass.toString() + ", MATCHING_CLASS = " + this.matchingClass.toString();
    }
}

