/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.transformations.io;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jwt.transformations.api.io.AbstractIODefinition;
import org.eclipse.jwt.transformations.api.io.ContentChangeListener;
import org.eclipse.jwt.transformations.api.io.IODefinition;
import org.eclipse.jwt.transformations.internal.TransformationsMessages;
import org.eclipse.jwt.transformations.widgets.file.AbstractFilePickerController;
import org.eclipse.jwt.transformations.widgets.file.FilePickerPathView;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileIODefinition<FileType>
extends AbstractIODefinition {
    public static final String EXTENSIONS_PARAMETER_NAME = "extensions";
    public static final String MUSTEXIST_PARAMETER_NAME = "mustExist";
    public static final String OPEN_FILE_AFTER_EXEC_PARAMETER_NAME = "openAfterExecCheckbox";
    public static final String OPEN_FILE_AFTER_EXEC_LABEL_PARAMETER_NAME = "openAfterExecCheckboxLabel";
    public static final String USE_CURRENT_WORKFLOW_AS_DEFAULT_PARAMETER_NAME = "useCurrentWorkflowAsDefault";
    public static final String USE_SELECTED_FILE_AS_DEFAULT_PARAMETER_NAME = "useSelectedFileAsDefault";
    public static final String USE_DEFAULT_FILE_LABEL_PARAMETER_NAME = "useDefaultFileCheckboxLabel";

    @Override
    public final IODefinition.IOHandle createIOControl(Composite parent, ContentChangeListener pageListener, IStructuredSelection currentSelection) {
        boolean useWorkflow = FileIODefinition.isTrue(this.getParameter(USE_CURRENT_WORKFLOW_AS_DEFAULT_PARAMETER_NAME));
        boolean useSelected = FileIODefinition.isTrue(this.getParameter(USE_SELECTED_FILE_AS_DEFAULT_PARAMETER_NAME));
        final AbstractFilePickerController<FileType> controller = this.createController(pageListener, this.getFileFilter(), this.getDefaultFile(currentSelection, useWorkflow, useSelected));
        final CustomizedFilePickerPathView view = new CustomizedFilePickerPathView(parent, controller);
        return new IODefinition.IOHandle(){

            @Override
            public boolean hasAllRequiredInformation() {
                return controller.getSelection() != null;
            }

            public FileType getValue() {
                return controller.getSelection();
            }

            public FilePickerPathView getControl() {
                return view;
            }

            @Override
            public void afterTransformation() throws CoreException {
                if (view.openCreatedFile) {
                    controller.openFile();
                }
            }
        };
    }

    protected abstract AbstractFilePickerController<FileType> createController(ContentChangeListener var1, AbstractFilePickerController.FileFilter var2, FileType var3);

    protected abstract FileType getDefaultFile(IStructuredSelection var1, boolean var2, boolean var3);

    private AbstractFilePickerController.FileFilter getFileFilter() {
        String extensionsParam = this.getParameter(EXTENSIONS_PARAMETER_NAME);
        String[] extensions = extensionsParam == null ? new String[]{} : extensionsParam.split(",");
        boolean mustExist = FileIODefinition.isTrue(this.getParameter(MUSTEXIST_PARAMETER_NAME));
        return new AbstractFilePickerController.FileFilter(extensions, mustExist);
    }

    private static boolean isTrue(String parameter) {
        return "true".equals(parameter);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CustomizedFilePickerPathView
    extends FilePickerPathView {
        private boolean openCreatedFile;

        public CustomizedFilePickerPathView(Composite parent, AbstractFilePickerController<?> controller) {
            super(parent, controller);
            this.openCreatedFile = false;
        }

        private void setUseCurrentModel(boolean value) {
            if (value) {
                this.controller.resetSelection();
            }
            this.fileText.setEnabled(!value);
            this.fileBrowse.setEnabled(!value);
        }

        @Override
        protected void init() {
            boolean useDefaultCheckbox = FileIODefinition.isTrue(FileIODefinition.this.getParameter(FileIODefinition.USE_CURRENT_WORKFLOW_AS_DEFAULT_PARAMETER_NAME)) | FileIODefinition.isTrue(FileIODefinition.this.getParameter(FileIODefinition.USE_SELECTED_FILE_AS_DEFAULT_PARAMETER_NAME));
            String defaultCheckboxLabel = FileIODefinition.this.getParameter(FileIODefinition.USE_DEFAULT_FILE_LABEL_PARAMETER_NAME);
            if (defaultCheckboxLabel == null) {
                defaultCheckboxLabel = TransformationsMessages.useDefaultFile;
            }
            if (useDefaultCheckbox) {
                final Button useCurrentModelCheckbox = new Button((Composite)this, 32);
                useCurrentModelCheckbox.setText(defaultCheckboxLabel);
                useCurrentModelCheckbox.setLayoutData((Object)new GridData(0, 0, false, false, 2, 1));
                super.init();
                useCurrentModelCheckbox.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        CustomizedFilePickerPathView.this.setUseCurrentModel(useCurrentModelCheckbox.getSelection());
                    }
                });
                useCurrentModelCheckbox.setSelection(true);
                this.setUseCurrentModel(true);
            } else {
                super.init();
            }
            boolean openFileCheckbox = FileIODefinition.isTrue(FileIODefinition.this.getParameter(FileIODefinition.OPEN_FILE_AFTER_EXEC_PARAMETER_NAME));
            String openFileCheckboxLabel = FileIODefinition.this.getParameter(FileIODefinition.OPEN_FILE_AFTER_EXEC_LABEL_PARAMETER_NAME);
            if (openFileCheckboxLabel == null) {
                openFileCheckboxLabel = TransformationsMessages.openCreatedFile;
            }
            if (openFileCheckbox) {
                final Button checkbox = new Button((Composite)this, 32);
                checkbox.setSelection(false);
                checkbox.setText(openFileCheckboxLabel);
                checkbox.setLayoutData((Object)new GridData(0, 0, false, false, 2, 1));
                checkbox.setEnabled(true);
                this.openCreatedFile = true;
                checkbox.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        CustomizedFilePickerPathView.this.openCreatedFile = checkbox.getSelection();
                    }
                });
            }
        }
    }
}

