/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.validation.core;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.runtime.evm.api.RuleSpecification;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.validation.core.ValidationEngine;
import org.eclipse.incquery.validation.core.Violation;
import org.eclipse.incquery.validation.core.ViolationCreationProcessor;
import org.eclipse.incquery.validation.core.api.IConstraint;
import org.eclipse.incquery.validation.core.api.IConstraintSpecification;
import org.eclipse.incquery.validation.core.api.IViolation;
import org.eclipse.incquery.validation.core.api.IViolationFilter;
import org.eclipse.incquery.validation.core.listeners.ConstraintListener;
import org.eclipse.incquery.validation.core.violationkey.CompositeSymmetricViolationKey;
import org.eclipse.incquery.validation.core.violationkey.CompositeViolationKey;
import org.eclipse.incquery.validation.core.violationkey.SimpleViolationKey;
import org.eclipse.incquery.validation.core.violationkey.ViolationKey;

public class Constraint
implements IConstraint {
    private Logger logger;
    private IConstraintSpecification specification;
    private ValidationEngine validationEngine;
    private RuleSpecification<IPatternMatch> ruleSpecification;
    private Map<ViolationKey, Violation> violationsMap;
    private Map<ConstraintListener, IViolationFilter> listeners;

    protected Constraint(IConstraintSpecification specification, ValidationEngine validationEngine, Logger logger) {
        this.specification = specification;
        this.validationEngine = validationEngine;
        this.logger = logger;
        this.violationsMap = new HashMap<ViolationKey, Violation>();
        this.listeners = new HashMap<ConstraintListener, IViolationFilter>();
    }

    @Override
    public IConstraintSpecification getSpecification() {
        return this.specification;
    }

    protected ValidationEngine getValidationEngine() {
        return this.validationEngine;
    }

    protected RuleSpecification<IPatternMatch> getRuleSpecification() {
        return this.ruleSpecification;
    }

    protected void setRuleSpecification(RuleSpecification<IPatternMatch> ruleSpecification) {
        this.ruleSpecification = ruleSpecification;
    }

    @Override
    public Collection<IViolation> getStoredViolations() {
        return this.violationsMap.values();
    }

    protected void addViolation(ViolationKey key, Violation violation) {
        this.violationsMap.put(key, violation);
    }

    protected Violation getViolation(ViolationKey key) {
        return this.violationsMap.get(key);
    }

    protected Violation removeViolation(ViolationKey key) {
        return this.violationsMap.remove(key);
    }

    @Override
    public Collection<IViolation> listViolations() {
        IncQueryMatcher matcher = null;
        try {
            matcher = this.validationEngine.getIncQueryEngine().getMatcher(this.specification.getQuerySpecification());
        }
        catch (IncQueryException e) {
            e.printStackTrace();
            return null;
        }
        HashMap<ViolationKey, Violation> violationMap = new HashMap<ViolationKey, Violation>();
        ViolationCreationProcessor violationCreationProcessor = new ViolationCreationProcessor(this, this.logger, violationMap);
        matcher.forEachMatch((IMatchProcessor)violationCreationProcessor);
        return violationMap.values();
    }

    @Override
    public Collection<IViolation> listViolations(IViolationFilter filter) {
        IncQueryMatcher matcher = null;
        try {
            matcher = this.validationEngine.getIncQueryEngine().getMatcher(this.specification.getQuerySpecification());
        }
        catch (IncQueryException e) {
            e.printStackTrace();
            return null;
        }
        HashMap<ViolationKey, Violation> violationMap = new HashMap<ViolationKey, Violation>();
        ViolationCreationProcessor violationCreationProcessor = new ViolationCreationProcessor(this, this.logger, violationMap);
        matcher.forEachMatch((IMatchProcessor)violationCreationProcessor);
        HashSet<IViolation> violations = new HashSet<IViolation>();
        for (Map.Entry entry : violationMap.entrySet()) {
            if (!filter.apply((IViolation)entry.getValue())) continue;
            violations.add((IViolation)entry.getValue());
        }
        return violations;
    }

    public Set<ConstraintListener> getListeners() {
        return ImmutableSet.copyOf(this.listeners.keySet());
    }

    @Override
    public boolean addListener(ConstraintListener listener) {
        boolean isNew;
        boolean bl = isNew = this.listeners.put(listener, null) == null;
        if (this.ruleSpecification == null) {
            this.validationEngine.addRuleSpecificationToExecutionSchema(this);
        }
        return isNew;
    }

    @Override
    public boolean addListener(ConstraintListener listener, IViolationFilter filter) {
        boolean isNew;
        boolean bl = isNew = this.listeners.put(listener, filter) == null;
        if (this.ruleSpecification == null) {
            this.validationEngine.addRuleSpecificationToExecutionSchema(this);
        }
        return isNew;
    }

    @Override
    public boolean removeListener(ConstraintListener listener) {
        boolean result;
        boolean bl = result = this.listeners.remove(listener) != null;
        if (this.listeners.isEmpty()) {
            this.validationEngine.removeRuleSpecificationFromExecutionSchema(this);
        }
        return result;
    }

    protected void notifyListenersViolationAppeared(Violation violation) {
        for (Map.Entry<ConstraintListener, IViolationFilter> entry : this.listeners.entrySet()) {
            if (entry.getValue() != null && !entry.getValue().apply(violation)) continue;
            entry.getKey().violationAppeared(violation);
        }
    }

    protected void notifyListenersViolationDisappeared(Violation violation) {
        for (Map.Entry<ConstraintListener, IViolationFilter> entry : this.listeners.entrySet()) {
            if (entry.getValue() != null && !entry.getValue().apply(violation)) continue;
            entry.getKey().violationDisappeared(violation);
        }
    }

    protected ViolationKey getViolationKey(IPatternMatch match) {
        Map<String, Object> keyObjectMap = this.getSpecification().getKeyObjects(match);
        Set<List<String>> symmetricKeyNames = this.getSpecification().getSymmetricKeyNames();
        if (keyObjectMap.size() < 2) {
            return new SimpleViolationKey(keyObjectMap.values().iterator().next());
        }
        if (symmetricKeyNames.isEmpty()) {
            return new CompositeViolationKey(keyObjectMap);
        }
        return new CompositeSymmetricViolationKey(keyObjectMap, symmetricKeyNames);
    }

    protected ViolationKey getViolationKey(Map<String, Object> keyObjectMap) {
        Set<List<String>> symmetricKeyNames = this.getSpecification().getSymmetricKeyNames();
        if (keyObjectMap.size() < 2) {
            return new SimpleViolationKey(keyObjectMap.values().iterator().next());
        }
        if (symmetricKeyNames.isEmpty()) {
            return new CompositeViolationKey(keyObjectMap);
        }
        return new CompositeSymmetricViolationKey(keyObjectMap, symmetricKeyNames);
    }
}

