/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.internal;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.base.api.DataTypeListener;
import org.eclipse.incquery.runtime.base.api.FeatureListener;
import org.eclipse.incquery.runtime.base.api.InstanceListener;
import org.eclipse.incquery.runtime.matchers.context.IPatternMatcherRuntimeContextListener;

public class BaseIndexListener
implements FeatureListener,
InstanceListener,
DataTypeListener {
    final Set<IPatternMatcherRuntimeContextListener> listeners = new HashSet<IPatternMatcherRuntimeContextListener>();
    private final IncQueryEngine iqEngine;

    public BaseIndexListener(IncQueryEngine iqEngine) {
        this.iqEngine = iqEngine;
    }

    public void addListener(IPatternMatcherRuntimeContextListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IPatternMatcherRuntimeContextListener listener) {
        this.listeners.remove(listener);
    }

    public void instanceInserted(EClass clazz, EObject instance) {
        for (IPatternMatcherRuntimeContextListener listener : this.listeners) {
            listener.updateUnary(true, (Object)instance, (Object)clazz);
        }
        for (IPatternMatcherRuntimeContextListener listener : this.listeners) {
            listener.updateInstantiation(true, (Object)clazz, (Object)instance);
        }
    }

    public void instanceDeleted(EClass clazz, EObject instance) {
        for (IPatternMatcherRuntimeContextListener listener : this.listeners) {
            listener.updateUnary(false, (Object)instance, (Object)clazz);
        }
        for (IPatternMatcherRuntimeContextListener listener : this.listeners) {
            listener.updateInstantiation(false, (Object)clazz, (Object)instance);
        }
    }

    public void dataTypeInstanceInserted(EDataType type, Object instance, boolean first) {
        if (first) {
            for (IPatternMatcherRuntimeContextListener listener : this.listeners) {
                listener.updateUnary(true, instance, (Object)type);
            }
            for (IPatternMatcherRuntimeContextListener listener : this.listeners) {
                listener.updateInstantiation(true, (Object)type, instance);
            }
        }
    }

    public void dataTypeInstanceDeleted(EDataType type, Object instance, boolean last) {
        if (last) {
            for (IPatternMatcherRuntimeContextListener listener : this.listeners) {
                listener.updateUnary(false, instance, (Object)type);
            }
            for (IPatternMatcherRuntimeContextListener listener : this.listeners) {
                listener.updateInstantiation(false, (Object)type, instance);
            }
        }
    }

    public void featureInserted(EObject host, EStructuralFeature feature, Object value) {
        for (IPatternMatcherRuntimeContextListener listener : this.listeners) {
            listener.updateBinaryEdge(true, (Object)host, value, (Object)feature);
        }
    }

    public void featureDeleted(EObject host, EStructuralFeature feature, Object value) {
        for (IPatternMatcherRuntimeContextListener listener : this.listeners) {
            listener.updateBinaryEdge(false, (Object)host, value, (Object)feature);
        }
    }
}

