/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.querybasedfeatures.runtime.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreEList;
import org.eclipse.incquery.querybasedfeatures.runtime.QueryBasedFeature;
import org.eclipse.incquery.querybasedfeatures.runtime.QueryBasedFeatureKind;
import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.runtime.api.IPatternMatch;

public class MultiValueQueryBasedFeature
extends QueryBasedFeature {
    private final Map<InternalEObject, List<Object>> manyRefMemory = new HashMap<InternalEObject, List<Object>>();

    protected MultiValueQueryBasedFeature(EStructuralFeature feature, boolean keepCache) {
        super(feature, keepCache);
    }

    public List<?> getManyReferenceValue(Object source) {
        if (this.isCached()) {
            List<Object> values = this.manyRefMemory.get(source);
            if (values == null) {
                values = new ArrayList<Object>();
            }
            return values;
        }
        final ArrayList values = new ArrayList();
        if (!this.isInitialized()) {
            return values;
        }
        IPatternMatch match = this.getMatcher().newEmptyMatch();
        match.set(this.getSourceParamName(), source);
        this.getMatcher().forEachMatch(match, (IMatchProcessor)new IMatchProcessor<IPatternMatch>(){

            public void process(IPatternMatch match) {
                values.add(MultiValueQueryBasedFeature.this.getTargetValue(match));
            }
        });
        return values;
    }

    @Override
    protected void processAppearedMatch(IPatternMatch signature) {
        Object target = this.getTargetValue(signature);
        InternalEObject source = this.getSourceValue(signature);
        if (target != null) {
            this.appendNotificationToList(new ENotificationImpl(source, 3, this.getFeature(), null, target));
            this.addToManyRefMemory(source, target);
        }
    }

    @Override
    protected void processDisappearedMatch(IPatternMatch signature) {
        Object target = this.getTargetValue(signature);
        InternalEObject source = this.getSourceValue(signature);
        if (target != null) {
            this.appendNotificationToList(new ENotificationImpl(source, 4, this.getFeature(), target, null));
            this.removeFromManyRefMemory(source, target);
        }
    }

    private void addToManyRefMemory(InternalEObject source, Object added) {
        if (this.isCached()) {
            List<Object> values = this.manyRefMemory.get(source);
            if (values == null) {
                values = new ArrayList<Object>();
                this.manyRefMemory.put(source, values);
            }
            values.add(added);
        }
    }

    private void removeFromManyRefMemory(InternalEObject source, Object removed) {
        if (this.isCached()) {
            List<Object> values = this.manyRefMemory.get(source);
            if (values == null) {
                this.engineForMatcher().getLogger().error((Object)"[IncqueryFeatureHandler] Space-time continuum breached (should never happen): removing from list that doesn't exist");
            }
            values.remove(removed);
        }
    }

    public EList getManyReferenceValueAsEList(Object source) {
        List<?> values = this.getManyReferenceValue(source);
        if (values.size() > 0) {
            return new EcoreEList.UnmodifiableEList((InternalEObject)source, this.getFeature(), values.size(), values.toArray());
        }
        return new EcoreEList.UnmodifiableEList((InternalEObject)source, this.getFeature(), 0, null);
    }

    @Override
    public QueryBasedFeatureKind getKind() {
        return QueryBasedFeatureKind.MANY_REFERENCE;
    }

    @Override
    protected void afterUpdate() {
    }

    @Override
    protected void beforeUpdate() {
    }

    @Override
    public Object getValue(Object source) {
        return this.getManyReferenceValue(source);
    }
}

