/*******************************************************************************
 * Copyright (c) 2010-2012, Zoltan Ujhelyi, Istvan Rath and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 *
 * Contributors:
 *   Zoltan Ujhelyi - initial API and implementation
 *******************************************************************************/
package org.eclipse.incquery.patternlanguage.emf.ui.internal;

import java.util.Collections;
import java.util.Map;

import org.apache.log4j.Logger;
import org.eclipse.incquery.tooling.core.generator.IncQueryGeneratorPlugin;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.xtext.ui.shared.SharedStateModule;
import org.eclipse.xtext.ui.shared.internal.SharedModule;
import org.eclipse.xtext.util.Modules2;
import org.osgi.framework.BundleContext;

import com.google.common.collect.Maps;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;

/**
 * The class was originally generated by Xtext, but has been extended to support various enhancements.
 */
public class EMFPatternLanguageActivator extends AbstractUIPlugin {

    public static final String ORG_ECLIPSE_INCQUERY_PATTERNLANGUAGE_EMF_EMFPATTERNLANGUAGE = "org.eclipse.incquery.patternlanguage.emf.EMFPatternLanguage";

    private static final Logger logger = Logger.getLogger(EMFPatternLanguageActivator.class);

    private static EMFPatternLanguageActivator INSTANCE;

    private Map<String, Injector> injectors = Collections.synchronizedMap(Maps
            .<String, Injector> newHashMapWithExpectedSize(1));

    @Override
    public void start(BundleContext context) throws Exception {
        super.start(context);
        INSTANCE = this;
    }

    @Override
    public void stop(BundleContext context) throws Exception {
        injectors.clear();
        INSTANCE = null;
        super.stop(context);
    }

    public static EMFPatternLanguageActivator getInstance() {
        return INSTANCE;
    }

    public Injector getInjector(String language) {
        synchronized (injectors) {
            Injector injector = injectors.get(language);
            if (injector == null) {
                injectors.put(language, injector = createInjector(language));
            }
            return injector;
        }
    }

    protected Injector createInjector(String language) {
        try {
            Module runtimeModule = getRuntimeModule(language);
            Module sharedStateModule = getSharedStateModule();
            Module uiModule = getUiModule(language);
            Module sharedModule = new SharedModule();
            Module mergedModule = Modules2.mixin(runtimeModule, sharedModule, sharedStateModule, uiModule);
            return Guice.createInjector(mergedModule);
        } catch (Exception e) {
            logger.error("Failed to create injector for " + language);
            logger.error(e.getMessage(), e);
            throw new RuntimeException("Failed to create injector for " + language, e);
        }
    }

    protected Module getRuntimeModule(String grammar) {
        if (ORG_ECLIPSE_INCQUERY_PATTERNLANGUAGE_EMF_EMFPATTERNLANGUAGE.equals(grammar)) {
            return IncQueryGeneratorPlugin.INSTANCE.getRuntimeModule();
        }

        throw new IllegalArgumentException(grammar);
    }

    protected Module getUiModule(String grammar) {
        if (ORG_ECLIPSE_INCQUERY_PATTERNLANGUAGE_EMF_EMFPATTERNLANGUAGE.equals(grammar)) {
            return new org.eclipse.incquery.patternlanguage.emf.ui.EMFPatternLanguageUiModule(this);
        }

        throw new IllegalArgumentException(grammar);
    }

    protected Module getSharedStateModule() {
        return new SharedStateModule();
    }

}
