/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.patternregistry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.incquery.patternlanguage.patternLanguage.Annotation;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.patternlanguage.patternLanguage.PatternModel;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.extensibility.QuerySpecificationRegistry;
import org.eclipse.incquery.runtime.patternregistry.IPatternInfo;
import org.eclipse.incquery.runtime.patternregistry.IPatternRegistryListener;
import org.eclipse.incquery.runtime.patternregistry.PatternRegistryUtil;
import org.eclipse.incquery.runtime.patternregistry.PatternTypeEnum;
import org.eclipse.incquery.runtime.patternregistry.internal.GeneratedPatternSource;
import org.eclipse.incquery.runtime.patternregistry.internal.PatternInfo;

public enum PatternRegistry {
    INSTANCE;

    private final List<IPatternRegistryListener> listeners = new ArrayList<IPatternRegistryListener>();
    private final List<IPatternInfo> patternInfos = new ArrayList<IPatternInfo>();
    private final Map<String, IPatternInfo> idToPatternInfoMap = new HashMap<String, IPatternInfo>();

    private PatternRegistry() {
        for (IPatternInfo patternInfo : GeneratedPatternSource.initializeRegisteredPatterns()) {
            this.addPatternToRegistry(patternInfo);
        }
    }

    public List<IPatternInfo> getAllPatternInfos() {
        return Collections.unmodifiableList(this.patternInfos);
    }

    public List<IPatternInfo> getPatternInfosByFile(IFile file) {
        ArrayList<IPatternInfo> resultList = new ArrayList<IPatternInfo>();
        if (file != null) {
            for (IPatternInfo patternInfo : this.patternInfos) {
                if (!file.equals((Object)patternInfo.getRelatedFile())) continue;
                resultList.add(patternInfo);
            }
        }
        return resultList;
    }

    public List<IPatternInfo> getPatternInfosByAnnotation(String nameOfAnnotation) {
        ArrayList<IPatternInfo> resultList = new ArrayList<IPatternInfo>();
        if (nameOfAnnotation != null) {
            block0: for (IPatternInfo patternInfo : this.patternInfos) {
                for (Annotation annotation : patternInfo.getAnnotations()) {
                    if (!nameOfAnnotation.equals(annotation.getName())) continue;
                    resultList.add(patternInfo);
                    continue block0;
                }
            }
        }
        return resultList;
    }

    public List<IPatternInfo> getPatternInfosByFQN(String fqn) {
        ArrayList<IPatternInfo> resultList = new ArrayList<IPatternInfo>();
        if (fqn != null) {
            for (IPatternInfo patternInfo : this.patternInfos) {
                if (!fqn.equals(patternInfo.getFqn())) continue;
                resultList.add(patternInfo);
            }
        }
        return resultList;
    }

    public IPatternInfo addPatternToRegistry(Pattern pattern, IFile relatedFile) {
        String id = PatternRegistryUtil.getUniquePatternIdentifier(pattern);
        if (this.idToPatternInfoMap.containsKey(id)) {
            return this.idToPatternInfoMap.get(id);
        }
        IQuerySpecification querySpecification = QuerySpecificationRegistry.getOrCreateQuerySpecification((Pattern)pattern);
        PatternInfo patternInfo = new PatternInfo(PatternTypeEnum.GENERIC, pattern, relatedFile, querySpecification);
        this.addPatternToRegistry(patternInfo);
        return patternInfo;
    }

    public List<IPatternInfo> addPatternsToRegistry(Resource resource, IFile relatedFile) {
        EObject eObject;
        ArrayList<IPatternInfo> resultList = new ArrayList<IPatternInfo>();
        if (resource != null && (eObject = (EObject)resource.getContents().get(0)) instanceof PatternModel) {
            PatternModel patternModel = (PatternModel)eObject;
            for (Pattern pattern : patternModel.getPatterns()) {
                resultList.add(this.addPatternToRegistry(pattern, relatedFile));
            }
        }
        return resultList;
    }

    private void addPatternToRegistry(IPatternInfo patternInfo) {
        this.patternInfos.add(patternInfo);
        this.idToPatternInfoMap.put(patternInfo.getId(), patternInfo);
        for (IPatternRegistryListener patternRegistryListener : this.listeners) {
            patternRegistryListener.patternAdded(patternInfo);
            patternRegistryListener.patternActivated(patternInfo);
        }
    }

    public void removePatternFromRegistry(Pattern pattern) {
        String id = PatternRegistryUtil.getUniquePatternIdentifier(pattern);
        if (this.idToPatternInfoMap.containsKey(id)) {
            IPatternInfo patternInfo = this.idToPatternInfoMap.get(id);
            this.removePatternFromRegistry(patternInfo);
        }
    }

    public void removePatternFromRegistry(IPatternInfo patternInfo) {
        String id = patternInfo.getId();
        if (this.idToPatternInfoMap.containsKey(id)) {
            this.patternInfos.remove(patternInfo);
            this.idToPatternInfoMap.remove(id);
            for (IPatternRegistryListener patternRegistryListener : this.listeners) {
                patternRegistryListener.patternDeactivated(patternInfo);
                patternRegistryListener.patternRemoved(patternInfo);
            }
        }
    }

    public boolean isPatternContainedInRegistry(Pattern pattern) {
        return this.idToPatternInfoMap.containsKey(PatternRegistryUtil.getUniquePatternIdentifier(pattern));
    }

    public void registerListener(IPatternRegistryListener patternRegistryListener) {
        this.listeners.add(patternRegistryListener);
    }

    public void unregisterListener(IPatternRegistryListener patternRegistryListener) {
        this.listeners.remove(patternRegistryListener);
    }
}

