/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.patternlanguage.emf.ui.validation;

import com.google.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.EMFPatternLanguagePackage;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.PackageImport;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.PatternModel;
import org.eclipse.incquery.patternlanguage.emf.validation.EMFPatternLanguageJavaValidator;
import org.eclipse.incquery.patternlanguage.patternLanguage.PatternLanguagePackage;
import org.eclipse.incquery.tooling.core.generator.genmodel.IEiqGenmodelProvider;
import org.eclipse.incquery.tooling.core.project.ProjectGenerationHelper;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.xtext.common.types.access.jdt.IJavaProjectProvider;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.Check;

public class GenmodelBasedEMFPatternLanguageJavaValidator
extends EMFPatternLanguageJavaValidator {
    @Inject
    private IEiqGenmodelProvider genmodelProvider;
    @Inject
    private IJavaProjectProvider projectProvider;
    @Inject
    private IStorage2UriMapper storage2UriMapper;
    @Inject
    private Logger logger;

    @Check
    public void checkPackageDeclaration(PatternModel model) {
        String declaredPackage;
        String actualPackage = this.getActualPackageName(model);
        if (!Strings.equal((String)actualPackage, (String)(declaredPackage = model.getPackageName()))) {
            this.error(String.format("The package declaration '%s' does not match the container '%s'", Strings.emptyIfNull((String)declaredPackage), Strings.emptyIfNull((String)actualPackage)), (EStructuralFeature)PatternLanguagePackage.Literals.PATTERN_MODEL__PACKAGE_NAME, "org.eclipse.incquery.patternlanguage.validation.IssueCodes.package_name_mismatch", new String[0]);
        }
    }

    protected String getActualPackageName(PatternModel model) {
        URI fileURI = model.eResource().getURI();
        for (Pair storage : this.storage2UriMapper.getStorages(fileURI)) {
            if (!(storage.getFirst() instanceof IFile)) continue;
            IPath fileWorkspacePath = ((IStorage)storage.getFirst()).getFullPath();
            IJavaProject javaProject = JavaCore.create((IProject)((IProject)storage.getSecond()));
            if (javaProject == null || !javaProject.exists() || !javaProject.isOpen()) continue;
            try {
                IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getPackageFragmentRoots();
                int n = iPackageFragmentRootArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IPath sourceFolderPath;
                    IResource resource;
                    IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                    if (!root.isArchive() && !root.isExternal() && (resource = root.getResource()) != null && (sourceFolderPath = resource.getFullPath()).isPrefixOf(fileWorkspacePath)) {
                        IPath classpathRelativePath = fileWorkspacePath.makeRelativeTo(sourceFolderPath);
                        return classpathRelativePath.removeLastSegments(1).toString().replace("/", ".");
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                this.logger.error((Object)"Error resolving package declaration for Pattern Model", (Throwable)e);
            }
        }
        return null;
    }

    @Check
    public void checkImportDependency(PackageImport importDecl) {
        GenModel genmodel;
        Resource res = importDecl.eResource();
        if (this.projectProvider == null || res == null) {
            return;
        }
        IJavaProject javaProject = this.projectProvider.getJavaProject(res.getResourceSet());
        if (javaProject == null) {
            return;
        }
        IProject project = javaProject.getProject();
        GenPackage genPackage = this.genmodelProvider.findGenPackage((EObject)importDecl, importDecl.getEPackage());
        if (genPackage != null && (genmodel = genPackage.getGenModel()) != null) {
            String modelPluginID = genmodel.getModelPluginID();
            try {
                if (!(modelPluginID == null || modelPluginID.isEmpty() || modelPluginID.equals(project.getName()) || ProjectGenerationHelper.checkBundleDependency((IProject)project, (String)modelPluginID))) {
                    this.error(String.format("To refer elements from the Package %s the bundle %s must be added as dependency", importDecl.getEPackage().getNsURI(), modelPluginID), (EObject)importDecl, (EStructuralFeature)EMFPatternLanguagePackage.Literals.PACKAGE_IMPORT__EPACKAGE, "org.eclipse.incquery.patternlanguage.emf.validation.IssueCodes.missing_import_dependency", new String[]{modelPluginID});
                }
            }
            catch (CoreException e) {
                this.logger.error((Object)"Error while checking the dependencies of the import declaration", (Throwable)e);
            }
        }
    }
}

