/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.jboss.logmanager.CopyOnWriteMap;
import org.jboss.logmanager.JDKSpecific;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.LogContextSelector;

public final class ClassLoaderLogContextSelector
implements LogContextSelector {
    private static final Permission REGISTER_LOG_CONTEXT_PERMISSION = new RuntimePermission("registerLogContext", null);
    private static final Permission UNREGISTER_LOG_CONTEXT_PERMISSION = new RuntimePermission("unregisterLogContext", null);
    private static final Permission LOG_API_PERMISSION = new RuntimePermission("logApiPermission", null);
    private final LogContextSelector defaultSelector;
    private final ConcurrentMap<ClassLoader, LogContext> contextMap = new CopyOnWriteMap<ClassLoader, LogContext>();
    private final Set<ClassLoader> logApiClassLoaders = Collections.newSetFromMap(new CopyOnWriteMap());
    private final boolean checkParentClassLoaders;
    private final Function<ClassLoader, LogContext> logContextFinder = new Function<ClassLoader, LogContext>(){

        @Override
        public LogContext apply(ClassLoader classLoader) {
            LogContext context = (LogContext)ClassLoaderLogContextSelector.this.contextMap.get(classLoader);
            if (context != null) {
                return context;
            }
            ClassLoader parent = classLoader.getParent();
            if (parent != null && ClassLoaderLogContextSelector.this.checkParentClassLoaders && !ClassLoaderLogContextSelector.this.logApiClassLoaders.contains(parent)) {
                return this.apply(parent);
            }
            return null;
        }
    };
    private final PrivilegedAction<LogContext> logContextAction = new PrivilegedAction<LogContext>(){

        @Override
        public LogContext run() {
            LogContext result = JDKSpecific.logContextFinder(ClassLoaderLogContextSelector.this.logApiClassLoaders, ClassLoaderLogContextSelector.this.logContextFinder);
            if (result != null) {
                return result;
            }
            return ClassLoaderLogContextSelector.this.defaultSelector.getLogContext();
        }
    };

    public ClassLoaderLogContextSelector(LogContextSelector defaultSelector) {
        this(defaultSelector, false);
    }

    public ClassLoaderLogContextSelector(LogContextSelector defaultSelector, boolean checkParentClassLoaders) {
        this.defaultSelector = defaultSelector;
        this.checkParentClassLoaders = checkParentClassLoaders;
    }

    public ClassLoaderLogContextSelector() {
        this(false);
    }

    public ClassLoaderLogContextSelector(boolean checkParentClassLoaders) {
        this(LogContext.DEFAULT_LOG_CONTEXT_SELECTOR, checkParentClassLoaders);
    }

    @Override
    public LogContext getLogContext() {
        return System.getSecurityManager() == null ? this.logContextAction.run() : AccessController.doPrivileged(this.logContextAction);
    }

    public boolean addLogApiClassLoader(ClassLoader apiClassLoader) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(LOG_API_PERMISSION);
        }
        return this.logApiClassLoaders.add(apiClassLoader);
    }

    public boolean removeLogApiClassLoader(ClassLoader apiClassLoader) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(LOG_API_PERMISSION);
        }
        return this.logApiClassLoaders.remove(apiClassLoader);
    }

    public void registerLogContext(ClassLoader classLoader, LogContext logContext) throws IllegalArgumentException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(REGISTER_LOG_CONTEXT_PERMISSION);
        }
        if (this.contextMap.putIfAbsent(classLoader, logContext) != null) {
            throw new IllegalArgumentException("ClassLoader instance is already registered to a log context (" + classLoader + ")");
        }
    }

    public boolean unregisterLogContext(ClassLoader classLoader, LogContext logContext) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(UNREGISTER_LOG_CONTEXT_PERMISSION);
        }
        return this.contextMap.remove(classLoader, logContext);
    }
}

