/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.application.client;

import java.time.Instant;
import java.util.Optional;

public final class TimeUntilDisconnectNotification {
    private static final long MAX_EXPIRY_MILLISECONDS = 864000000000L;
    private final String tenantId;
    private final String deviceId;
    private final Integer ttd;
    private final Instant readyUntil;
    private final Instant creationTime;

    public TimeUntilDisconnectNotification(String tenantId, String deviceId, Integer ttd, Instant creationTime) {
        this.tenantId = tenantId;
        this.deviceId = deviceId;
        this.ttd = ttd;
        this.creationTime = creationTime;
        this.readyUntil = TimeUntilDisconnectNotification.getReadyUntilInstantFromTtd(ttd, creationTime);
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getTenantAndDeviceId() {
        return Optional.ofNullable(this.tenantId).map(t -> t + "/" + this.deviceId).orElse(null);
    }

    public Integer getTtd() {
        return this.ttd;
    }

    public Instant getReadyUntil() {
        return this.readyUntil;
    }

    public Instant getCreationTime() {
        return this.creationTime;
    }

    public String toString() {
        return "TimeUntilDisconnectNotification [" + "tenant-id: " + this.tenantId + ", device-id: " + this.deviceId + ", ttd: " + this.ttd + ", readyUntil: " + this.readyUntil + ", creationTime: " + this.creationTime + "]";
    }

    private static Instant getReadyUntilInstantFromTtd(Integer ttd, Instant startingFrom) {
        if (ttd == -1) {
            return Instant.MAX;
        }
        if (startingFrom == null) {
            return Instant.MIN;
        }
        return startingFrom.plusSeconds(ttd.intValue());
    }

    public long getMillisecondsUntilExpiry() {
        if (this.getReadyUntil().equals(Instant.MAX)) {
            return 864000000000L;
        }
        long milliseconds = this.getReadyUntil().minusMillis(Instant.now().toEpochMilli()).toEpochMilli();
        return milliseconds > 0L ? milliseconds : 0L;
    }

    public static boolean isDeviceCurrentlyConnected(Integer ttd, Long creationTime) {
        return Optional.ofNullable(ttd).map(ttdValue -> {
            if (ttdValue == -1) {
                return true;
            }
            if (ttdValue == 0) {
                return false;
            }
            if (creationTime == null) {
                return false;
            }
            Instant creationTimeInstant = Instant.ofEpochMilli(creationTime);
            return Instant.now().isBefore(creationTimeInstant.plusSeconds(ttdValue.intValue()));
        }).orElse(false);
    }
}

