/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ExecConfig;
import io.fabric8.kubernetes.api.model.ExecEnvVar;
import io.fabric8.kubernetes.api.model.ExecEnvVarBuilder;
import io.fabric8.kubernetes.api.model.ExecEnvVarFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ExecConfigFluent<A extends ExecConfigFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private List<String> args = new ArrayList<String>();
    private String command;
    private ArrayList<ExecEnvVarBuilder> env = new ArrayList();
    private String installHint;
    private String interactiveMode;
    private Boolean provideClusterInfo;
    private Map<String, Object> additionalProperties;

    public ExecConfigFluent() {
    }

    public ExecConfigFluent(ExecConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ExecConfig instance) {
        ExecConfig execConfig = instance = instance != null ? instance : new ExecConfig();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withArgs(instance.getArgs());
            this.withCommand(instance.getCommand());
            this.withEnv(instance.getEnv());
            this.withInstallHint(instance.getInstallHint());
            this.withInteractiveMode(instance.getInteractiveMode());
            this.withProvideClusterInfo(instance.getProvideClusterInfo());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A addToArgs(int index, String item) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        this.args.add(index, item);
        return (A)this;
    }

    public A setToArgs(int index, String item) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        this.args.set(index, item);
        return (A)this;
    }

    public A addToArgs(String ... items) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        for (String item : items) {
            this.args.add(item);
        }
        return (A)this;
    }

    public A addAllToArgs(Collection<String> items) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        for (String item : items) {
            this.args.add(item);
        }
        return (A)this;
    }

    public A removeFromArgs(String ... items) {
        if (this.args == null) {
            return (A)this;
        }
        for (String item : items) {
            this.args.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromArgs(Collection<String> items) {
        if (this.args == null) {
            return (A)this;
        }
        for (String item : items) {
            this.args.remove(item);
        }
        return (A)this;
    }

    public List<String> getArgs() {
        return this.args;
    }

    public String getArg(int index) {
        return this.args.get(index);
    }

    public String getFirstArg() {
        return this.args.get(0);
    }

    public String getLastArg() {
        return this.args.get(this.args.size() - 1);
    }

    public String getMatchingArg(Predicate<String> predicate) {
        for (String item : this.args) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingArg(Predicate<String> predicate) {
        for (String item : this.args) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withArgs(List<String> args) {
        if (args != null) {
            this.args = new ArrayList<String>();
            for (String item : args) {
                this.addToArgs(item);
            }
        } else {
            this.args = null;
        }
        return (A)this;
    }

    public A withArgs(String ... args) {
        if (this.args != null) {
            this.args.clear();
            this._visitables.remove("args");
        }
        if (args != null) {
            for (String item : args) {
                this.addToArgs(item);
            }
        }
        return (A)this;
    }

    public boolean hasArgs() {
        return this.args != null && !this.args.isEmpty();
    }

    public String getCommand() {
        return this.command;
    }

    public A withCommand(String command) {
        this.command = command;
        return (A)this;
    }

    public boolean hasCommand() {
        return this.command != null;
    }

    public A addToEnv(int index, ExecEnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        ExecEnvVarBuilder builder = new ExecEnvVarBuilder(item);
        if (index < 0 || index >= this.env.size()) {
            this._visitables.get("env").add(builder);
            this.env.add(builder);
        } else {
            this._visitables.get("env").add(index, builder);
            this.env.add(index, builder);
        }
        return (A)this;
    }

    public A setToEnv(int index, ExecEnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        ExecEnvVarBuilder builder = new ExecEnvVarBuilder(item);
        if (index < 0 || index >= this.env.size()) {
            this._visitables.get("env").add(builder);
            this.env.add(builder);
        } else {
            this._visitables.get("env").set(index, builder);
            this.env.set(index, builder);
        }
        return (A)this;
    }

    public A addToEnv(ExecEnvVar ... items) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        for (ExecEnvVar item : items) {
            ExecEnvVarBuilder builder = new ExecEnvVarBuilder(item);
            this._visitables.get("env").add(builder);
            this.env.add(builder);
        }
        return (A)this;
    }

    public A addAllToEnv(Collection<ExecEnvVar> items) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        for (ExecEnvVar item : items) {
            ExecEnvVarBuilder builder = new ExecEnvVarBuilder(item);
            this._visitables.get("env").add(builder);
            this.env.add(builder);
        }
        return (A)this;
    }

    public A removeFromEnv(ExecEnvVar ... items) {
        if (this.env == null) {
            return (A)this;
        }
        for (ExecEnvVar item : items) {
            ExecEnvVarBuilder builder = new ExecEnvVarBuilder(item);
            this._visitables.get("env").remove(builder);
            this.env.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromEnv(Collection<ExecEnvVar> items) {
        if (this.env == null) {
            return (A)this;
        }
        for (ExecEnvVar item : items) {
            ExecEnvVarBuilder builder = new ExecEnvVarBuilder(item);
            this._visitables.get("env").remove(builder);
            this.env.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromEnv(Predicate<ExecEnvVarBuilder> predicate) {
        if (this.env == null) {
            return (A)this;
        }
        Iterator<ExecEnvVarBuilder> each = this.env.iterator();
        Object visitables = this._visitables.get("env");
        while (each.hasNext()) {
            ExecEnvVarBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<ExecEnvVar> buildEnv() {
        return this.env != null ? ExecConfigFluent.build(this.env) : null;
    }

    public ExecEnvVar buildEnv(int index) {
        return this.env.get(index).build();
    }

    public ExecEnvVar buildFirstEnv() {
        return this.env.get(0).build();
    }

    public ExecEnvVar buildLastEnv() {
        return this.env.get(this.env.size() - 1).build();
    }

    public ExecEnvVar buildMatchingEnv(Predicate<ExecEnvVarBuilder> predicate) {
        for (ExecEnvVarBuilder item : this.env) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingEnv(Predicate<ExecEnvVarBuilder> predicate) {
        for (ExecEnvVarBuilder item : this.env) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEnv(List<ExecEnvVar> env) {
        if (this.env != null) {
            this._visitables.get("env").clear();
        }
        if (env != null) {
            this.env = new ArrayList();
            for (ExecEnvVar item : env) {
                this.addToEnv(item);
            }
        } else {
            this.env = null;
        }
        return (A)this;
    }

    public A withEnv(ExecEnvVar ... env) {
        if (this.env != null) {
            this.env.clear();
            this._visitables.remove("env");
        }
        if (env != null) {
            for (ExecEnvVar item : env) {
                this.addToEnv(item);
            }
        }
        return (A)this;
    }

    public boolean hasEnv() {
        return this.env != null && !this.env.isEmpty();
    }

    public A addNewEnv(String name, String value) {
        return this.addToEnv(new ExecEnvVar(name, value));
    }

    public EnvNested<A> addNewEnv() {
        return new EnvNested(-1, null);
    }

    public EnvNested<A> addNewEnvLike(ExecEnvVar item) {
        return new EnvNested(-1, item);
    }

    public EnvNested<A> setNewEnvLike(int index, ExecEnvVar item) {
        return new EnvNested(index, item);
    }

    public EnvNested<A> editEnv(int index) {
        if (this.env.size() <= index) {
            throw new RuntimeException("Can't edit env. Index exceeds size.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public EnvNested<A> editFirstEnv() {
        if (this.env.size() == 0) {
            throw new RuntimeException("Can't edit first env. The list is empty.");
        }
        return this.setNewEnvLike(0, this.buildEnv(0));
    }

    public EnvNested<A> editLastEnv() {
        int index = this.env.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last env. The list is empty.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public EnvNested<A> editMatchingEnv(Predicate<ExecEnvVarBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.env.size(); ++i) {
            if (!predicate.test(this.env.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching env. No match found.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public String getInstallHint() {
        return this.installHint;
    }

    public A withInstallHint(String installHint) {
        this.installHint = installHint;
        return (A)this;
    }

    public boolean hasInstallHint() {
        return this.installHint != null;
    }

    public String getInteractiveMode() {
        return this.interactiveMode;
    }

    public A withInteractiveMode(String interactiveMode) {
        this.interactiveMode = interactiveMode;
        return (A)this;
    }

    public boolean hasInteractiveMode() {
        return this.interactiveMode != null;
    }

    public Boolean getProvideClusterInfo() {
        return this.provideClusterInfo;
    }

    public A withProvideClusterInfo(Boolean provideClusterInfo) {
        this.provideClusterInfo = provideClusterInfo;
        return (A)this;
    }

    public boolean hasProvideClusterInfo() {
        return this.provideClusterInfo != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExecConfigFluent that = (ExecConfigFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.args, that.args)) {
            return false;
        }
        if (!Objects.equals(this.command, that.command)) {
            return false;
        }
        if (!Objects.equals(this.env, that.env)) {
            return false;
        }
        if (!Objects.equals(this.installHint, that.installHint)) {
            return false;
        }
        if (!Objects.equals(this.interactiveMode, that.interactiveMode)) {
            return false;
        }
        if (!Objects.equals(this.provideClusterInfo, that.provideClusterInfo)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.args, this.command, this.env, this.installHint, this.interactiveMode, this.provideClusterInfo, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.args != null && !this.args.isEmpty()) {
            sb.append("args:");
            sb.append(this.args + ",");
        }
        if (this.command != null) {
            sb.append("command:");
            sb.append(this.command + ",");
        }
        if (this.env != null && !this.env.isEmpty()) {
            sb.append("env:");
            sb.append(this.env + ",");
        }
        if (this.installHint != null) {
            sb.append("installHint:");
            sb.append(this.installHint + ",");
        }
        if (this.interactiveMode != null) {
            sb.append("interactiveMode:");
            sb.append(this.interactiveMode + ",");
        }
        if (this.provideClusterInfo != null) {
            sb.append("provideClusterInfo:");
            sb.append(this.provideClusterInfo + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withProvideClusterInfo() {
        return this.withProvideClusterInfo(true);
    }

    public class EnvNested<N>
    extends ExecEnvVarFluent<EnvNested<N>>
    implements Nested<N> {
        ExecEnvVarBuilder builder;
        int index;

        EnvNested(int index, ExecEnvVar item) {
            this.index = index;
            this.builder = new ExecEnvVarBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ExecConfigFluent.this.setToEnv(this.index, this.builder.build());
        }

        public N endEnv() {
            return this.and();
        }
    }
}

