/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.vertx.codegen.lang;

import io.smallrye.mutiny.vertx.codegen.lang.CodeGenHelper;
import io.smallrye.mutiny.vertx.codegen.lang.CodeWriter;
import io.vertx.codegen.ClassModel;
import io.vertx.codegen.Helper;
import io.vertx.codegen.type.ClassTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.stream.Collectors;

public class ClassDeclarationCodeWriter
implements CodeWriter {
    @Override
    public void generate(ClassModel model, PrintWriter writer) {
        ClassTypeInfo type = model.getType();
        writer.print("public ");
        if (model.isConcrete()) {
            writer.print("class");
        } else {
            writer.print("interface");
        }
        writer.print(" ");
        writer.print(Helper.getSimpleName(model.getIfaceFQCN()));
        if (model.isConcrete() && CodeGenHelper.hasParentClass(model)) {
            writer.print(" extends ");
            writer.print(this.genTypeName(model.getConcreteSuperType()));
        }
        ArrayList<Object> interfaces = new ArrayList<Object>();
        if ("io.vertx.core.buffer.Buffer".equals(type.getName())) {
            interfaces.add("io.vertx.core.shareddata.impl.ClusterSerializable");
        }
        interfaces.addAll(model.getAbstractSuperTypes().stream().map(this::genTypeName).collect(Collectors.toList()));
        if (model.isHandler()) {
            interfaces.add("io.vertx.core.Handler<" + this.genTypeName(model.getHandlerArg()) + ">");
            interfaces.add("java.util.function.Consumer<" + this.genTypeName(model.getHandlerArg()) + ">");
        }
        if (model.isIterable()) {
            interfaces.add("java.lang.Iterable<" + this.genTypeName(model.getIterableArg()) + ">");
        }
        if (model.isIterator()) {
            interfaces.add("java.util.Iterator<" + this.genTypeName(model.getIteratorArg()) + ">");
        }
        if (model.isFunction()) {
            TypeInfo[] functionArgs = model.getFunctionArgs();
            interfaces.add("java.util.function.Function<" + this.genTypeName(functionArgs[0]) + ", " + this.genTypeName(functionArgs[1]) + ">");
        }
        if (!interfaces.isEmpty()) {
            writer.print(interfaces.stream().collect(Collectors.joining(", ", model.isConcrete() ? " implements " : " extends ", "")));
        }
        writer.println(" {");
        writer.println();
    }
}

