/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.kafka;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.hono.client.kafka.CommonKafkaClientConfigProperties;
import org.eclipse.hono.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKafkaConfigProperties {
    private static final AtomicInteger ID_COUNTER = new AtomicInteger();
    private static final String COMPONENT_UID_DEFAULT = AbstractKafkaConfigProperties.getK8sComponentUId();
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private String componentUId = COMPONENT_UID_DEFAULT;
    private Map<String, String> commonClientConfig;
    private Map<String, String> specificClientConfig;

    protected AbstractKafkaConfigProperties() {
    }

    private static String getK8sComponentUId() {
        if (System.getenv("KUBERNETES_SERVICE_HOST") != null) {
            String podName = System.getenv("HOSTNAME");
            String random = UUID.randomUUID().toString().replace("-", "").substring(0, 12);
            return String.format("%s_%s", podName, random);
        }
        return null;
    }

    public final void setCommonClientConfig(CommonKafkaClientConfigProperties commonConfig) {
        Objects.requireNonNull(commonConfig);
        this.commonClientConfig = commonConfig.getCommonClientConfig();
    }

    protected final void setSpecificClientConfig(Map<String, String> specificConfig) {
        this.specificClientConfig = Objects.requireNonNull(specificConfig);
    }

    public final void overrideComponentUidUsedForClientId(String componentUId) {
        this.componentUId = componentUId;
    }

    public final boolean isConfigured() {
        return this.containsMinimalConfiguration(this.commonClientConfig) || this.containsMinimalConfiguration(this.specificClientConfig);
    }

    public String getBootstrapServers() {
        String result = null;
        if (this.specificClientConfig != null) {
            result = this.specificClientConfig.get("bootstrap.servers");
        }
        if (result == null && this.commonClientConfig != null) {
            result = this.commonClientConfig.get("bootstrap.servers");
        }
        return result;
    }

    protected final Map<String, String> getConfig(String clientName) {
        Objects.requireNonNull(clientName);
        HashMap<String, String> newConfig = new HashMap<String, String>();
        if (this.commonClientConfig != null) {
            newConfig.putAll(this.commonClientConfig);
        }
        if (this.specificClientConfig != null) {
            newConfig.putAll(this.specificClientConfig);
        }
        this.setUniqueClientId(newConfig, clientName);
        return newConfig;
    }

    protected final void overrideConfigProperty(Map<String, String> config, String key, String value) {
        Objects.requireNonNull(config);
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        this.log.trace("setting Kafka config property [{}={}]", (Object)key, (Object)value);
        String oldValue = config.put(key, value);
        if (oldValue != null) {
            this.log.debug("provided Kafka configuration contains property [{}={}], changing it to [{}]", key, oldValue, value);
        }
    }

    private void setUniqueClientId(Map<String, String> config, String clientName) {
        String uniqueClientIdSuffix = Optional.ofNullable(this.componentUId).map(uid -> String.format("%s_%s", uid, ID_COUNTER.getAndIncrement())).orElseGet(() -> UUID.randomUUID().toString());
        String uniqueClientId = Optional.ofNullable(config.get("client.id")).map(clientIdPrefix -> String.format("%s-%s-%s", clientIdPrefix, clientName, uniqueClientIdSuffix)).orElseGet(() -> String.format("%s-%s", clientName, uniqueClientIdSuffix));
        config.put("client.id", uniqueClientId);
    }

    protected final boolean containsMinimalConfiguration(Map<String, String> properties) {
        return Optional.ofNullable(properties).map(props -> !Strings.isNullOrEmpty(props.get("bootstrap.servers"))).orElse(false);
    }
}

