/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.proton.sasl.impl;

import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.proton.sasl.ProtonSaslMechanism;
import io.vertx.proton.sasl.ProtonSaslMechanismFactory;
import io.vertx.proton.sasl.impl.ProtonSaslAnonymousFactoryImpl;
import io.vertx.proton.sasl.impl.ProtonSaslExternalFactoryImpl;
import io.vertx.proton.sasl.impl.ProtonSaslPlainFactoryImpl;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;

public class ProtonSaslMechanismFinderImpl {
    private static Logger LOG = LoggerFactory.getLogger(ProtonSaslMechanismFinderImpl.class);

    public static ProtonSaslMechanism findMatchingMechanism(String username, String password, Principal localPrincipal, Set<String> mechRestrictions, String ... remoteMechanisms) {
        ProtonSaslMechanism match = null;
        ArrayList<ProtonSaslMechanism> found = new ArrayList<ProtonSaslMechanism>();
        for (String remoteMechanism : remoteMechanisms) {
            ProtonSaslMechanismFactory factory = ProtonSaslMechanismFinderImpl.findMechanismFactory(remoteMechanism);
            if (factory == null) continue;
            ProtonSaslMechanism mech = factory.createMechanism();
            if (mechRestrictions != null && !mechRestrictions.isEmpty() && !mechRestrictions.contains(remoteMechanism)) {
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("Skipping " + remoteMechanism + " mechanism because it is not in the configured mechanisms restriction set");
                continue;
            }
            if (mech.isApplicable(username, password, localPrincipal)) {
                found.add(mech);
                continue;
            }
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace("Skipping " + mech + " mechanism because the available credentials are not sufficient");
        }
        if (!found.isEmpty()) {
            Collections.sort(found);
            match = (ProtonSaslMechanism)found.get(found.size() - 1);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Best match for SASL auth was: " + match);
        }
        return match;
    }

    protected static ProtonSaslMechanismFactory findMechanismFactory(String name) {
        if (name == null || name.isEmpty()) {
            LOG.warn("No SASL mechanism name was specified");
            return null;
        }
        ProtonSaslMechanismFactory factory = null;
        if ("PLAIN".equals(name)) {
            factory = new ProtonSaslPlainFactoryImpl();
        } else if ("ANONYMOUS".equals(name)) {
            factory = new ProtonSaslAnonymousFactoryImpl();
        } else if ("EXTERNAL".equals(name)) {
            factory = new ProtonSaslExternalFactoryImpl();
        }
        return factory;
    }
}

