/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Context;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.helpers.queues.Queues;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.FlatMapManager;
import io.smallrye.mutiny.subscription.BackPressureFailure;
import io.smallrye.mutiny.subscription.ContextSupport;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;

public final class MultiFlatMapOp<I, O>
extends AbstractMultiOperator<I, O> {
    private final Function<? super I, ? extends Publisher<? extends O>> mapper;
    private final boolean postponeFailurePropagation;
    private final int maxConcurrency;
    private final int requests;
    private final Supplier<? extends Queue<O>> mainQueueSupplier;

    public MultiFlatMapOp(Multi<? extends I> upstream, Function<? super I, ? extends Publisher<? extends O>> mapper, boolean postponeFailurePropagation, int maxConcurrency, int requests) {
        super(upstream);
        this.mapper = ParameterValidation.nonNull(mapper, "mapper");
        this.postponeFailurePropagation = postponeFailurePropagation;
        this.maxConcurrency = ParameterValidation.positive(maxConcurrency, "maxConcurrency");
        this.mainQueueSupplier = Queues.get(maxConcurrency);
        this.requests = ParameterValidation.positive(requests, "requests");
    }

    @Override
    public void subscribe(MultiSubscriber<? super O> subscriber) {
        if (subscriber == null) {
            throw new NullPointerException("The subscriber must not be `null`");
        }
        FlatMapMainSubscriber<? super I, ? super O> sub = new FlatMapMainSubscriber<I, O>(subscriber, this.mapper, this.postponeFailurePropagation, this.maxConcurrency, this.mainQueueSupplier, this.requests);
        this.upstream.subscribe(Infrastructure.onMultiSubscription(this.upstream, sub));
    }

    static final class FlatMapInner<O>
    implements Subscription,
    MultiSubscriber<O>,
    ContextSupport {
        final FlatMapMainSubscriber<?, O> parent;
        final int requests;
        final int limit;
        volatile Subscription subscription = null;
        private static final AtomicReferenceFieldUpdater<FlatMapInner, Subscription> SUBSCRIPTION_UPDATER = AtomicReferenceFieldUpdater.newUpdater(FlatMapInner.class, Subscription.class, "subscription");
        long produced;
        volatile Queue<O> queue;
        volatile boolean done;
        int index;

        FlatMapInner(FlatMapMainSubscriber<?, O> parent, int requests) {
            this.parent = parent;
            this.requests = requests;
            this.limit = Subscriptions.unboundedOrLimit(requests);
        }

        @Override
        public void onSubscribe(Subscription s) {
            Objects.requireNonNull(s);
            if (SUBSCRIPTION_UPDATER.compareAndSet(this, null, s)) {
                s.request(Subscriptions.unboundedOrRequests(this.requests));
            }
        }

        @Override
        public void onItem(O item) {
            this.parent.tryEmit(this, item);
        }

        @Override
        public void onFailure(Throwable failure) {
            Objects.requireNonNull(failure);
            this.done = true;
            this.parent.innerError(this, failure);
        }

        @Override
        public void onCompletion() {
            this.done = true;
            this.parent.innerComplete();
        }

        @Override
        public void request(long n) {
            long p = this.produced + n;
            if (p >= (long)this.limit) {
                this.produced = 0L;
                this.subscription.request(p);
            } else {
                this.produced = p;
            }
        }

        @Override
        public void cancel() {
            this.cancel(true);
        }

        public void cancel(boolean doNotCancel) {
            Subscription last;
            if (!doNotCancel && (last = SUBSCRIPTION_UPDATER.getAndSet(this, Subscriptions.CANCELLED)) != null) {
                last.cancel();
            }
            if (this.queue != null) {
                this.queue.clear();
                this.queue = null;
            }
        }

        @Override
        public Context context() {
            return this.parent.context();
        }
    }

    public static final class FlatMapMainSubscriber<I, O>
    extends FlatMapManager<FlatMapInner<O>>
    implements MultiSubscriber<I>,
    Subscription,
    ContextSupport {
        final boolean delayError;
        final int maxConcurrency;
        final int requests;
        final int limit;
        final Function<? super I, ? extends Publisher<? extends O>> mapper;
        final Supplier<? extends Queue<O>> mainQueueSupplier;
        final Supplier<? extends Queue<O>> innerQueueSupplier;
        final MultiSubscriber<? super O> downstream;
        volatile Queue<O> queue;
        final AtomicReference<Throwable> failures = new AtomicReference();
        volatile boolean done;
        volatile boolean cancelled;
        volatile Subscription upstream = null;
        private static final AtomicReferenceFieldUpdater<FlatMapMainSubscriber, Subscription> UPSTREAM_UPDATER = AtomicReferenceFieldUpdater.newUpdater(FlatMapMainSubscriber.class, Subscription.class, "upstream");
        AtomicLong requested = new AtomicLong();
        AtomicInteger wip = new AtomicInteger();
        static final FlatMapInner[] EMPTY_INNER_ARRAY = new FlatMapInner[0];
        static final FlatMapInner[] TERMINATED_INNER_ARRAY = new FlatMapInner[0];
        int lastIndex;

        public FlatMapMainSubscriber(MultiSubscriber<? super O> downstream, Function<? super I, ? extends Publisher<? extends O>> mapper, boolean delayError, int concurrency, Supplier<? extends Queue<O>> mainQueueSupplier, int requests) {
            this.downstream = downstream;
            this.mapper = mapper;
            this.delayError = delayError;
            this.maxConcurrency = concurrency;
            this.mainQueueSupplier = mainQueueSupplier;
            this.requests = requests;
            this.innerQueueSupplier = requests == 0 ? Queues.getXsQueueSupplier() : Queues.get(requests);
            this.limit = Subscriptions.unboundedOrLimit(concurrency);
        }

        FlatMapInner<O>[] empty() {
            return EMPTY_INNER_ARRAY;
        }

        FlatMapInner<O>[] terminated() {
            return TERMINATED_INNER_ARRAY;
        }

        FlatMapInner<O>[] newArray(int size) {
            return new FlatMapInner[size];
        }

        @Override
        void setIndex(FlatMapInner<O> entry, int index) {
            entry.index = index;
        }

        @Override
        void unsubscribeEntry(FlatMapInner<O> entry, boolean fromOnError) {
            entry.cancel(fromOnError);
        }

        @Override
        public void request(long n) {
            if (n > 0L) {
                Subscriptions.add(this.requested, n);
                this.drain();
            } else {
                this.downstream.onFailure(new IllegalArgumentException("Invalid requests, must be greater than 0"));
            }
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                if (this.wip.getAndIncrement() == 0) {
                    this.clearQueue();
                    UPSTREAM_UPDATER.getAndSet(this, Subscriptions.CANCELLED).cancel();
                    this.unsubscribe();
                }
            }
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (UPSTREAM_UPDATER.compareAndSet(this, null, s)) {
                this.downstream.onSubscribe(this);
                s.request(Subscriptions.unboundedOrRequests(this.maxConcurrency));
            }
        }

        @Override
        public void onItem(I item) {
            Publisher<O> p;
            if (this.done) {
                return;
            }
            try {
                p = this.mapper.apply(item);
                if (p == null) {
                    throw new NullPointerException("The mapper returned `null`");
                }
            }
            catch (Throwable e) {
                this.cancelled = true;
                this.done = true;
                Subscriptions.addFailure(this.failures, e);
                this.cancelUpstream(false);
                this.handleTerminationIfDone();
                return;
            }
            FlatMapInner inner = new FlatMapInner(this, this.requests);
            if (this.add(inner)) {
                p.subscribe(inner);
            }
        }

        @Override
        public void onFailure(Throwable failure) {
            if (this.done) {
                Infrastructure.handleDroppedException(failure);
                return;
            }
            Subscriptions.addFailure(this.failures, failure);
            this.done = true;
            if (!this.delayError) {
                for (FlatMapInner<O> inner : this.inners.getAndSet(this.terminated())) {
                    if (inner == null) continue;
                    inner.cancel(false);
                }
            }
            this.drain();
        }

        @Override
        public void onCompletion() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.drain();
        }

        void tryEmit(FlatMapInner<O> inner, O item) {
            if (this.wip.compareAndSet(0, 1)) {
                long req = this.requested.get();
                Queue q = inner.queue;
                if (req != 0L && (q == null || q.isEmpty())) {
                    this.downstream.onNext(item);
                    if (req != Long.MAX_VALUE) {
                        this.requested.decrementAndGet();
                    }
                    inner.request(1L);
                } else {
                    if (q == null) {
                        q = this.getOrCreateInnerQueue(inner);
                    }
                    if (!q.offer(item)) {
                        this.failOverflow();
                        inner.done = true;
                        this.drainLoop();
                        return;
                    }
                }
                if (this.wip.decrementAndGet() == 0) {
                    return;
                }
                this.drainLoop();
            } else {
                Queue<O> q = this.getOrCreateInnerQueue(inner);
                if (!q.offer(item)) {
                    this.failOverflow();
                    inner.done = true;
                }
                this.drain();
            }
        }

        void drain() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            this.drainLoop();
        }

        void drainLoop() {
            boolean again;
            int missed = 1;
            MultiSubscriber<O> a = this.downstream;
            do {
                boolean d;
                long e;
                FlatMapInner[] as = (FlatMapInner[])this.get();
                int n = as.length;
                Queue<O> sq = this.queue;
                boolean noSources = this.isEmpty();
                if (this.ifDoneOrCancelled()) {
                    return;
                }
                again = false;
                long r = this.requested.get();
                long replenishMain = 0L;
                if (r != 0L && sq != null) {
                    for (e = 0L; e != r; ++e) {
                        boolean empty;
                        d = this.done;
                        O v = sq.poll();
                        boolean bl = empty = v == null;
                        if (this.ifDoneOrCancelled()) {
                            return;
                        }
                        if (empty) break;
                        a.onItem(v);
                    }
                    if (e != 0L) {
                        replenishMain += e;
                        if (r != Long.MAX_VALUE) {
                            r = this.requested.addAndGet(-e);
                        }
                        e = 0L;
                        again = true;
                    }
                }
                if (r != 0L && !noSources) {
                    int j = this.lastIndex;
                    for (int i = 0; i < n; ++i) {
                        if (this.cancelled) {
                            this.cancelUpstream(false);
                            return;
                        }
                        FlatMapInner inner = as[j];
                        if (inner != null) {
                            d = inner.done;
                            Queue q = inner.queue;
                            if (d && q == null) {
                                this.remove(inner.index);
                                again = true;
                                ++replenishMain;
                            } else if (q != null) {
                                while (e != r) {
                                    boolean empty;
                                    Object v;
                                    d = inner.done;
                                    try {
                                        v = q.poll();
                                    }
                                    catch (Throwable ex) {
                                        Subscriptions.addFailure(this.failures, ex);
                                        v = null;
                                        d = true;
                                    }
                                    boolean bl = empty = v == null;
                                    if (this.ifDoneOrCancelled()) {
                                        return;
                                    }
                                    if (d && empty) {
                                        this.remove(inner.index);
                                        again = true;
                                        ++replenishMain;
                                        break;
                                    }
                                    if (empty) break;
                                    a.onItem(v);
                                    ++e;
                                }
                                if (e == r) {
                                    d = inner.done;
                                    boolean empty = q.isEmpty();
                                    if (d && empty) {
                                        this.remove(inner.index);
                                        again = true;
                                        ++replenishMain;
                                    }
                                }
                                if (e != 0L) {
                                    if (!inner.done) {
                                        inner.request(e);
                                    }
                                    if (r != Long.MAX_VALUE && (r = this.requested.addAndGet(-e)) == 0L) break;
                                    e = 0L;
                                }
                            }
                        }
                        if (r == 0L) break;
                        if (++j != n) continue;
                        j = 0;
                    }
                    this.lastIndex = j;
                }
                if (r == 0L && !noSources) {
                    as = (FlatMapInner[])this.get();
                    n = as.length;
                    for (int i = 0; i < n; ++i) {
                        boolean empty;
                        if (this.cancelled) {
                            this.cancelUpstream(false);
                            return;
                        }
                        FlatMapInner inner = as[i];
                        if (inner == null) continue;
                        d = inner.done;
                        Queue q = inner.queue;
                        boolean bl = empty = q == null || q.isEmpty();
                        if (!empty) break;
                        if (!d || !empty) continue;
                        this.remove(inner.index);
                        again = true;
                        ++replenishMain;
                    }
                }
                if (replenishMain == 0L || this.done || this.cancelled) continue;
                this.upstream.request(replenishMain);
            } while (again || (missed = this.wip.addAndGet(-missed)) != 0);
        }

        private void cancelUpstream(boolean fromOnError) {
            this.clearQueue();
            Subscription subscription = UPSTREAM_UPDATER.getAndSet(this, Subscriptions.CANCELLED);
            if (subscription != null) {
                subscription.cancel();
            }
            this.unsubscribe(fromOnError);
        }

        private void clearQueue() {
            if (this.queue != null) {
                this.queue.clear();
                this.queue = null;
            }
        }

        boolean ifDoneOrCancelled() {
            if (this.cancelled) {
                this.cancelUpstream(false);
                return true;
            }
            return this.handleTerminationIfDone();
        }

        private boolean handleTerminationIfDone() {
            boolean isEmpty;
            boolean wasDone = this.done;
            boolean bl = isEmpty = this.isEmpty() && (this.queue == null || this.queue.isEmpty());
            if (this.delayError) {
                if (wasDone && isEmpty) {
                    Throwable e = this.failures.get();
                    if (e != null && e != Subscriptions.TERMINATED) {
                        Throwable throwable = this.failures.getAndSet(Subscriptions.TERMINATED);
                        this.downstream.onFailure(throwable);
                    } else {
                        this.downstream.onCompletion();
                    }
                    return true;
                }
            } else if (wasDone) {
                Throwable e = this.failures.get();
                if (e != null && e != Subscriptions.TERMINATED) {
                    Throwable throwable = this.failures.getAndSet(Subscriptions.TERMINATED);
                    this.clearQueue();
                    this.unsubscribe(true);
                    this.downstream.onFailure(throwable);
                    return true;
                }
                if (isEmpty) {
                    this.downstream.onCompletion();
                    return true;
                }
            }
            return false;
        }

        void innerError(FlatMapInner<O> inner, Throwable fail) {
            if (fail != null) {
                if (Subscriptions.addFailure(this.failures, fail)) {
                    inner.done = true;
                    if (!this.delayError) {
                        this.cancelUpstream(true);
                        this.downstream.onFailure(fail);
                        return;
                    }
                    this.drain();
                }
            } else {
                this.drain();
            }
        }

        void failOverflow() {
            BackPressureFailure e = new BackPressureFailure("Buffer full, cannot emit item");
            Subscriptions.addFailure(this.failures, e);
        }

        void innerComplete() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            this.drainLoop();
        }

        Queue<O> getOrCreateInnerQueue(FlatMapInner<O> inner) {
            Queue q = inner.queue;
            if (q == null) {
                inner.queue = q = this.innerQueueSupplier.get();
            }
            return q;
        }

        @Override
        public Context context() {
            if (this.downstream instanceof ContextSupport) {
                return ((ContextSupport)((Object)this.downstream)).context();
            }
            return Context.empty();
        }
    }
}

