/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.bindings.internal;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javafx.beans.binding.ListBinding;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;

public class FixListBinding<A>
extends ListBinding<A> {
    private final ObservableList<A> source;
    private ObservableList<A> fixed;
    private ListChangeListener<A> changeListener = this::onSourceChange;
    private WeakListChangeListener<A> weakChangeListener = new WeakListChangeListener(this.changeListener);

    public FixListBinding(ObservableList<A> source) {
        this.source = source;
        this.source.addListener(this.weakChangeListener);
    }

    private void onSourceChange(ListChangeListener.Change<? extends A> change) {
        if (this.fixed == null) {
            this.fixed = FXCollections.observableArrayList();
        }
        while (change.next()) {
            if (change.wasRemoved() && change.wasAdded() && change.getRemovedSize() == this.fixed.size()) {
                int maxIdx = Math.max(change.getRemovedSize(), change.getAddedSize());
                int firstMismatch = -1;
                int i = 0;
                while (i < maxIdx) {
                    boolean inAdded;
                    boolean inRemoved = change.getRemovedSize() > i;
                    boolean bl = inAdded = change.getAddedSize() > i;
                    if (inAdded != inRemoved) {
                        firstMismatch = i;
                        break;
                    }
                    if (inAdded && inRemoved) {
                        Object removed = change.getRemoved().get(i);
                        Object added = change.getAddedSubList().get(i);
                        if (added != removed && !Objects.equals(added, removed)) {
                            firstMismatch = i;
                            break;
                        }
                    }
                    ++i;
                }
                int offset = change.getAddedSize() - change.getRemovedSize();
                int firstMatchAfterChange = change.getRemovedSize();
                int i2 = firstMismatch;
                while (i2 < maxIdx) {
                    int idxAdded = i2 + offset;
                    if (idxAdded >= 0) {
                        boolean inAdded;
                        boolean inRemoved = change.getRemovedSize() > i2;
                        boolean bl = inAdded = change.getAddedSize() > idxAdded;
                        if (inAdded && inRemoved) {
                            Object removed = change.getRemoved().get(i2);
                            Object added = change.getAddedSubList().get(idxAdded);
                            if (added == removed || Objects.equals(added, removed)) {
                                firstMatchAfterChange = i2;
                                break;
                            }
                        }
                    }
                    ++i2;
                }
                int removed = firstMatchAfterChange - firstMismatch;
                if (firstMismatch != -1) {
                    List subList = this.fixed.subList(firstMismatch, firstMatchAfterChange);
                    subList.clear();
                    if (offset + removed <= 0) continue;
                    List add = change.getAddedSubList().subList(firstMismatch, firstMismatch + offset + removed);
                    subList.addAll(add);
                    continue;
                }
                this.fixed.setAll((Collection)change.getAddedSubList());
                continue;
            }
            if (change.wasPermutated()) {
                this.fixed.subList(change.getFrom(), change.getTo()).clear();
                this.fixed.addAll(change.getFrom(), (Collection)change.getList().subList(change.getFrom(), change.getTo()));
                continue;
            }
            if (change.wasRemoved()) {
                this.fixed.subList(change.getFrom(), change.getFrom() + change.getRemovedSize()).clear();
            }
            if (!change.wasAdded()) continue;
            this.fixed.addAll(change.getFrom(), (Collection)change.getAddedSubList());
        }
    }

    protected ObservableList<A> computeValue() {
        if (this.fixed == null) {
            this.fixed = FXCollections.observableArrayList(this.source);
        }
        return this.fixed;
    }

    public void dispose() {
        this.source.removeListener(this.weakChangeListener);
        super.dispose();
    }
}

