/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.merge.java.facade.ast;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.codegen.merge.java.facade.JAbstractType;
import org.eclipse.emf.codegen.merge.java.facade.JNode;
import org.eclipse.emf.codegen.merge.java.facade.NodeConverter;
import org.eclipse.emf.codegen.merge.java.facade.ast.ASTFacadeHelper;
import org.eclipse.emf.codegen.merge.java.facade.ast.ASTJEnum;
import org.eclipse.emf.codegen.merge.java.facade.ast.ASTJEnumConstant;
import org.eclipse.emf.codegen.merge.java.facade.ast.ASTJField;
import org.eclipse.emf.codegen.merge.java.facade.ast.ASTJNode;
import org.eclipse.emf.codegen.merge.java.facade.ast.ASTJType;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASTNodeConverter
implements NodeConverter {
    protected ASTFacadeHelper facadeHelper;

    public ASTNodeConverter(ASTFacadeHelper facadeHelper) {
        assert (facadeHelper != null);
        this.facadeHelper = facadeHelper;
    }

    public ASTFacadeHelper getFacadeHelper() {
        return this.facadeHelper;
    }

    @Override
    public JAbstractType convert(JAbstractType abstractType, Class<? extends JAbstractType> cls) {
        try {
            Converter converter = null;
            if (ASTJEnum.class.isAssignableFrom(cls) && abstractType instanceof ASTJType) {
                converter = new TypeToEnumConverter((ASTJType)abstractType);
            } else if (ASTJType.class.isAssignableFrom(cls) && abstractType instanceof ASTJEnum) {
                converter = new EnumToTypeConverter((ASTJEnum)abstractType);
            }
            return converter != null ? (JAbstractType)converter.convert() : null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected abstract class Converter {
        protected Converter() {
        }

        public abstract JNode convert();

        protected void moveChildren(JNode source, JNode target) {
            for (JNode child : source.getChildren()) {
                ASTNodeConverter.this.getFacadeHelper().remove(child);
                ASTNodeConverter.this.getFacadeHelper().addChild(target, child);
            }
        }

        protected void replaceNode(JNode existingNode, JNode newNode) {
            ASTNodeConverter.this.getFacadeHelper().insertSibling(existingNode, newNode, false);
            ASTNodeConverter.this.getFacadeHelper().remove(existingNode);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class EnumToTypeConverter
    extends Converter {
        protected ASTJEnum astjEnum;
        protected AST ast;
        protected List<JNode> enumChildren;
        protected Map<String, ASTJField> fieldInitializersMap = new HashMap<String, ASTJField>();
        protected Map<ASTJField, Integer> fieldIndexesMap = new HashMap<ASTJField, Integer>();
        protected ASTJNode<?> lastFinalFieldUsed = null;

        public EnumToTypeConverter(ASTJEnum astjEnum) {
            this.astjEnum = astjEnum;
            this.ast = ((EnumDeclaration)astjEnum.getASTNode()).getAST();
            this.enumChildren = astjEnum.getChildren();
            int i = 0;
            for (JNode child : this.enumChildren) {
                ASTJField field;
                if (!(child instanceof ASTJField) || ((field = (ASTJField)child).getFlags() & 0x19) == 0) continue;
                this.fieldInitializersMap.put(field.getInitializer(), field);
                this.fieldIndexesMap.put(field, i++);
            }
        }

        @Override
        public ASTJType convert() {
            TypeDeclaration typeDeclaration = this.ast.newTypeDeclaration();
            ASTJType type = (ASTJType)ASTNodeConverter.this.getFacadeHelper().convertToNode(typeDeclaration);
            type.setRewriter(this.astjEnum.getRewriter());
            type.setName(this.astjEnum.getName());
            type.setFlags(this.astjEnum.getFlags());
            type.setComment(this.astjEnum.getComment());
            ArrayList convertedEnumConstants = new ArrayList(this.enumChildren.size());
            for (JNode jNode : this.enumChildren) {
                ASTJNode originalNode = (ASTJNode)jNode;
                if (originalNode instanceof ASTJEnumConstant) {
                    ASTJEnumConstant constant = (ASTJEnumConstant)originalNode;
                    convertedEnumConstants.add(this.convertEnumConstToField(constant));
                    continue;
                }
                this.astjEnum.remove(originalNode);
                type.addChild(originalNode);
            }
            for (ASTJNode aSTJNode : convertedEnumConstants) {
                if (this.lastFinalFieldUsed == null) {
                    type.addChild(aSTJNode);
                    continue;
                }
                type.insertSibling(this.lastFinalFieldUsed, aSTJNode, false);
                this.lastFinalFieldUsed = aSTJNode;
            }
            this.replaceNode(this.astjEnum, type);
            return type;
        }

        protected ASTJNode<?> convertEnumConstToField(ASTJEnumConstant enumConstant) {
            VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
            this.ast.newFieldDeclaration(variableDeclarationFragment);
            ASTJField field = (ASTJField)ASTNodeConverter.this.getFacadeHelper().convertToNode(variableDeclarationFragment);
            field.setRewriter(enumConstant.getRewriter());
            field.setName(enumConstant.getName());
            field.setComment(enumConstant.getComment());
            field.setType(enumConstant.getParent().getName());
            field.setFlags(25);
            this.setFieldInitializer(field, enumConstant);
            this.moveChildren(enumConstant, field);
            return field;
        }

        protected void setFieldInitializer(ASTJField field, ASTJEnumConstant enumConstant) {
            String[] arguments = enumConstant.getArguments();
            String body = enumConstant.getBody();
            ClassInstanceCreation classInstanceCreation = this.ast.newClassInstanceCreation();
            field.setNodeProperty((ASTNode)classInstanceCreation, enumConstant.getParent().getName(), (StructuralPropertyDescriptor)ClassInstanceCreation.TYPE_PROPERTY, 43);
            if (arguments != null) {
                int i = 0;
                while (i < arguments.length) {
                    ASTJField constantField;
                    if (arguments[i] != null && arguments[i].length() > 0 && (constantField = this.fieldInitializersMap.get(arguments[i])) != null) {
                        arguments[i] = constantField.getName();
                        if (this.lastFinalFieldUsed != null) {
                            int lastFinalFieldUsedIndex;
                            int constantFieldUsedIndex = this.fieldIndexesMap.get(constantField);
                            if (constantFieldUsedIndex > (lastFinalFieldUsedIndex = this.fieldIndexesMap.get(this.lastFinalFieldUsed).intValue())) {
                                this.lastFinalFieldUsed = constantField;
                            }
                        } else {
                            this.lastFinalFieldUsed = constantField;
                        }
                    }
                    ++i;
                }
                field.setListNodeProperty((ASTNode)classInstanceCreation, arguments, ClassInstanceCreation.ARGUMENTS_PROPERTY, 42);
            }
            if (body != null && body.length() > 0) {
                field.setTrackedNodeProperty((ASTNode)classInstanceCreation, body, (StructuralPropertyDescriptor)ClassInstanceCreation.ANONYMOUS_CLASS_DECLARATION_PROPERTY, 1);
            }
            field.setNodeProperty((ASTNode)field.getVariableDeclarationFragment(), classInstanceCreation, (StructuralPropertyDescriptor)VariableDeclarationFragment.INITIALIZER_PROPERTY);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class TypeToEnumConverter
    extends Converter {
        protected ASTJType type;
        protected AST ast;
        protected List<JNode> typeChildren;
        protected Map<String, ASTJField> fieldNamesMap = new HashMap<String, ASTJField>();

        public TypeToEnumConverter(ASTJType type) {
            this.type = type;
            this.ast = ((TypeDeclaration)type.getASTNode()).getAST();
            this.typeChildren = type.getChildren();
            for (JNode child : this.typeChildren) {
                if (!(child instanceof ASTJField)) continue;
                this.fieldNamesMap.put(child.getName(), (ASTJField)child);
            }
        }

        @Override
        public ASTJEnum convert() {
            EnumDeclaration enumDeclaration = this.ast.newEnumDeclaration();
            ASTJEnum astjEnum = (ASTJEnum)ASTNodeConverter.this.getFacadeHelper().convertToNode(enumDeclaration);
            astjEnum.setRewriter(this.type.getRewriter());
            astjEnum.setName(this.type.getName());
            astjEnum.setFlags(this.type.getFlags());
            astjEnum.setComment(this.type.getComment());
            for (JNode child : this.typeChildren) {
                ASTJNode<?> nodeToRemove;
                ASTJNode<?> nodeToInsert = nodeToRemove = (ASTJNode<?>)child;
                if (nodeToRemove instanceof ASTJField) {
                    ASTJField field = (ASTJField)nodeToRemove;
                    nodeToInsert = this.convertFieldToEnumConst(field);
                }
                this.type.remove(nodeToRemove);
                astjEnum.addChild(nodeToInsert);
            }
            this.replaceNode(this.type, astjEnum);
            return astjEnum;
        }

        protected ASTJNode<?> convertFieldToEnumConst(ASTJField field) {
            String parentType;
            int flags = field.getFlags();
            if ((flags & 0x19) == 0) {
                return field;
            }
            JNode parent = field.getParent();
            String string = parentType = parent == null ? null : parent.getName();
            if (parentType == null || !parentType.equals(field.getType())) {
                return field;
            }
            EnumConstantDeclaration enumConstantDeclaration = this.ast.newEnumConstantDeclaration();
            ASTJEnumConstant enumConstant = (ASTJEnumConstant)ASTNodeConverter.this.getFacadeHelper().convertToNode(enumConstantDeclaration);
            enumConstant.setRewriter(field.getRewriter());
            enumConstant.setName(field.getName());
            enumConstant.setComment(field.getComment());
            this.setEnumConstantArgumentsAndBody(enumConstant, field);
            this.moveChildren(field, enumConstant);
            return enumConstant;
        }

        protected void setEnumConstantArgumentsAndBody(ASTJEnumConstant enumConstant, ASTJField field) {
            Expression initializer = field.getVariableDeclarationFragment().getInitializer();
            if (initializer == null || initializer.getNodeType() != 14) {
                return;
            }
            ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)initializer;
            String[] arguments = field.convertASTNodeListToStringArray(classInstanceCreation.arguments());
            int i = 0;
            while (i < arguments.length) {
                String fieldInitializer;
                ASTJField existingField = this.fieldNamesMap.get(arguments[i]);
                if (existingField != null && (fieldInitializer = existingField.getInitializer()) != null && fieldInitializer.length() > 0) {
                    arguments[i] = fieldInitializer;
                }
                ++i;
            }
            enumConstant.setArguments(arguments);
            enumConstant.setBody(ASTNodeConverter.this.getFacadeHelper().toString((ASTNode)classInstanceCreation.getAnonymousClassDeclaration()));
        }
    }
}

