/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.trace.node;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.generator.trace.node.CompositeGeneratorNode;
import org.eclipse.xtext.generator.trace.node.GeneratorNodeExtensions;
import org.eclipse.xtext.generator.trace.node.IGeneratorNode;
import org.eclipse.xtext.generator.trace.node.IndentNode;
import org.eclipse.xtext.generator.trace.node.NewLineNode;
import org.eclipse.xtext.generator.trace.node.TextNode;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class TemplateNode
extends CompositeGeneratorNode
implements StringConcatenationClient.TargetStringConcatenation {
    private final GeneratorNodeExtensions nodeFactory;
    private CompositeGeneratorNode currentParent = this;
    private boolean isEmptyLine = true;
    private final Splitter lineSplitter = Splitter.on((Pattern)Pattern.compile("\\R"));

    public TemplateNode(StringConcatenationClient contents, GeneratorNodeExtensions nodeFactory) {
        this.nodeFactory = nodeFactory;
        StringConcatenationClient.appendTo((StringConcatenationClient)contents, (StringConcatenationClient.TargetStringConcatenation)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(Object object, String indentation) {
        boolean _greaterThan;
        int _length = indentation.length();
        boolean bl = _greaterThan = _length > 0;
        if (_greaterThan) {
            CompositeGeneratorNode before = this.currentParent;
            try {
                IndentNode _indentNode = new IndentNode(indentation, false, true);
                this.currentParent = _indentNode;
                List<IGeneratorNode> _children = before.getChildren();
                _children.add(this.currentParent);
                this.append(object);
            }
            finally {
                this.currentParent = before;
            }
        } else {
            this.append(object);
        }
    }

    public void append(Object object) {
        if (object == null) {
            return;
        }
        boolean _matched = false;
        if (object instanceof StringConcatenationClient) {
            _matched = true;
            this.nodeFactory.appendTemplate(this.currentParent, (StringConcatenationClient)object);
        }
        if (!_matched && object instanceof IGeneratorNode) {
            _matched = true;
            List<IGeneratorNode> _children = this.currentParent.getChildren();
            _children.add((IGeneratorNode)object);
        }
        if (!_matched) {
            String str = object.toString();
            Iterator iter = this.lineSplitter.split((CharSequence)str).iterator();
            while (iter.hasNext()) {
                boolean _not;
                String segment = (String)iter.next();
                boolean _isEmpty = segment.isEmpty();
                boolean bl = _not = !_isEmpty;
                if (_not) {
                    this.isEmptyLine = false;
                }
                this.nodeFactory.append(this.currentParent, segment);
                boolean _hasNext = iter.hasNext();
                if (!_hasNext) continue;
                this.newLine();
            }
        }
    }

    protected Iterable<IGeneratorNode> leafsBackwards(IGeneratorNode it) {
        Iterable<Object> _switchResult = null;
        boolean _matched = false;
        if (it instanceof CompositeGeneratorNode) {
            _matched = true;
            Functions.Function1 _function = it_1 -> this.leafsBackwards((IGeneratorNode)it_1);
            Functions.Function2 _function_1 = (p1, p2) -> Iterables.concat((Iterable)p1, (Iterable)p2);
            _switchResult = (Iterable)IterableExtensions.reduce((Iterable)ListExtensions.map((List)ListExtensions.reverseView(((CompositeGeneratorNode)it).getChildren()), (Functions.Function1)_function), (Functions.Function2)_function_1);
        }
        if (!_matched) {
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new IGeneratorNode[]{it}));
        }
        return _switchResult;
    }

    public void appendImmediate(Object object, String indentation) {
        ArrayList removed = Lists.newArrayList();
        for (int i = this.currentParent.getChildren().size() - 1; i >= 0; --i) {
            IGeneratorNode node = this.currentParent.getChildren().get(i);
            if (node instanceof TextNode && !TemplateNode.hasContent(((TextNode)node).getText())) {
                IGeneratorNode _remove = this.currentParent.getChildren().remove(i);
                removed.add(_remove);
                continue;
            }
            if (node instanceof NewLineNode) {
                IGeneratorNode _remove_1 = this.currentParent.getChildren().remove(i);
                removed.add(_remove_1);
                continue;
            }
            this.append(object, indentation);
            Consumer<IGeneratorNode> _function = it -> this.append(it, indentation);
            ListExtensions.reverse((List)removed).forEach(_function);
            return;
        }
        this.append(object, indentation);
    }

    protected static boolean hasContent(CharSequence s) {
        for (int i = 0; i < s.length(); ++i) {
            boolean _not;
            boolean _isWhitespace = Character.isWhitespace(s.charAt(i));
            boolean bl = _not = !_isWhitespace;
            if (!_not) continue;
            return true;
        }
        return false;
    }

    public void newLine() {
        this.nodeFactory.appendNewLine(this.currentParent);
    }

    public void newLineIfNotEmpty() {
        this.nodeFactory.appendNewLineIfNotEmpty(this.currentParent);
    }

    public char charAt(int index) {
        throw new UnsupportedOperationException();
    }

    public int length() {
        throw new UnsupportedOperationException();
    }

    public CharSequence subSequence(int start, int end) {
        throw new UnsupportedOperationException();
    }
}

