/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.text.ui.contentassist;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.event.Event;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ListView;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.web.WebView;
import javafx.stage.PopupWindow;
import org.eclipse.fx.text.ui.ITextViewer;
import org.eclipse.fx.text.ui.contentassist.ContentAssistContextData;
import org.eclipse.fx.text.ui.contentassist.ContentAssistant;
import org.eclipse.fx.text.ui.contentassist.ICompletionProposal;
import org.eclipse.fx.text.ui.contentassist.IContentAssistListener;
import org.eclipse.fx.ui.controls.list.SimpleListCell;
import org.eclipse.fx.ui.controls.styledtext.StyledTextContent;
import org.eclipse.fx.ui.controls.styledtext.TextChangedEvent;
import org.eclipse.fx.ui.controls.styledtext.TextChangingEvent;
import org.eclipse.fx.ui.controls.styledtext.VerifyEvent;
import org.eclipse.jface.text.IDocument;

public class ContentProposalPopup
implements IContentAssistListener {
    ITextViewer viewer;
    private PopupWindow stage;
    private ListView<ICompletionProposal> proposalList;
    private WebView documentationView;
    private String prefix;
    int offset;
    private Function<ContentAssistContextData, List<ICompletionProposal>> proposalComputer;
    private ContentAssistant fContentAssistant;
    private ChangeListener<Number> selectionChange;
    private StyledTextContent.TextChangeListener textChangeListener = new StyledTextContent.TextChangeListener(){

        public void textSet(TextChangedEvent event) {
            ContentProposalPopup.this.offset = ContentProposalPopup.this.viewer.getTextWidget().getCaretOffset();
            ContentProposalPopup.this.updateProposals();
        }

        public void textChanging(TextChangingEvent event) {
        }

        public void textChanged(TextChangedEvent event) {
            ContentProposalPopup.this.offset = ContentProposalPopup.this.viewer.getTextWidget().getCaretOffset();
            ContentProposalPopup.this.updateProposals();
        }
    };

    public ContentProposalPopup(ContentAssistant assistant, ITextViewer viewer, Function<ContentAssistContextData, List<ICompletionProposal>> proposalComputer) {
        this.viewer = viewer;
        this.proposalComputer = proposalComputer;
        this.fContentAssistant = assistant;
        this.selectionChange = this::onSelectionChange;
    }

    public void displayProposals(List<ICompletionProposal> proposalList, int offset, Point2D position) {
        this.setup();
        this.prefix = "";
        this.offset = offset;
        this.proposalList.setItems(FXCollections.observableArrayList(proposalList));
        this.proposalList.getSelectionModel().select(0);
        this.stage.setX(position.getX());
        this.stage.setY(position.getY());
        this.stage.setWidth(300.0);
        this.stage.setHeight(200.0);
        this.stage.requestFocus();
        this.stage.setOnShowing(this::subscribe);
        this.stage.setOnHidden(this::unsubscribe);
        this.stage.show(this.viewer.getTextWidget().getScene().getWindow());
    }

    private void subscribe(Event e) {
        this.viewer.getTextWidget().getContent().addTextChangeListener(this.textChangeListener);
        this.viewer.getTextWidget().caretOffsetProperty().addListener(this.selectionChange);
    }

    private void unsubscribe(Event e) {
        this.viewer.getTextWidget().getContent().removeTextChangeListener(this.textChangeListener);
        this.viewer.getTextWidget().caretOffsetProperty().removeListener(this.selectionChange);
    }

    private void onSelectionChange(Observable x, Number oldSelection, Number newSelection) {
        this.offset = this.viewer.getTextWidget().getCaretOffset();
        this.updateProposals();
    }

    private void updateProposals() {
        List<ICompletionProposal> list = this.proposalComputer.apply(new ContentAssistContextData(this.offset, this.viewer.getDocument()));
        if (!list.isEmpty()) {
            this.proposalList.setItems(FXCollections.observableArrayList(list));
            this.proposalList.scrollTo(0);
            this.proposalList.getSelectionModel().select(0);
            this.proposalList.requestFocus();
        } else {
            this.stage.hide();
        }
    }

    private void cancelProposal() {
        this.stage.hide();
    }

    private void applySelectedProposal() {
        ICompletionProposal selectedItem = (ICompletionProposal)this.proposalList.getSelectionModel().getSelectedItem();
        if (selectedItem != null) {
            IDocument document = this.viewer.getDocument();
            selectedItem.apply(document);
            this.viewer.getTextWidget().setSelection(selectedItem.getSelection(document));
            this.stage.hide();
            this.fContentAssistant.showContextInformation(selectedItem.getContextInformation(), this.offset);
        }
    }

    private void handleMouseClicked(MouseEvent event) {
        if (event.isStillSincePress() && event.getClickCount() == 2) {
            this.applySelectedProposal();
        }
    }

    private void handleKeyPressed(KeyEvent event) {
        switch (event.getCode()) {
            case ESCAPE: {
                event.consume();
                this.cancelProposal();
                break;
            }
            case ENTER: {
                event.consume();
                this.applySelectedProposal();
                break;
            }
            case LEFT: {
                event.consume();
                this.updateProposals();
                break;
            }
            case RIGHT: {
                event.consume();
                this.updateProposals();
                break;
            }
        }
    }

    private static String getDocumentation(ICompletionProposal proposal) {
        if (proposal != null) {
            return "<html><body><pre>" + proposal.getHoverInfo() + "</pre></body></html>";
        }
        return "<html></html>";
    }

    private void setup() {
        if (this.stage == null) {
            this.stage = new PopupWindow(){};
            this.stage.setAutoFix(false);
            this.stage.setWidth(300.0);
            this.stage.setHeight(200.0);
            BorderPane p = new BorderPane();
            p.setPrefHeight(200.0);
            p.setPrefWidth(600.0);
            this.stage.getScene().addEventFilter(KeyEvent.KEY_PRESSED, this::handleKeyPressed);
            this.stage.getScene().getStylesheets().addAll((Collection)this.viewer.getTextWidget().getScene().getStylesheets());
            this.proposalList = new ListView();
            this.proposalList.setMinWidth(300.0);
            this.proposalList.getStyleClass().add((Object)"content-proposal-list");
            this.proposalList.setOnMouseClicked(this::handleMouseClicked);
            this.documentationView = new WebView();
            this.documentationView.setPrefWidth(300.0);
            this.documentationView.getStyleClass().add((Object)"content-proposal-doc");
            this.proposalList.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.documentationView.getEngine().loadContent(ContentProposalPopup.getDocumentation(newValue)));
            Function<ICompletionProposal, CharSequence> label = c -> c.getLabel();
            Function<ICompletionProposal, Node> graphic = c -> c.getGraphic();
            Function<ICompletionProposal, List> css = c -> Collections.emptyList();
            this.proposalList.setCellFactory(v -> new SimpleListCell(label, graphic, css));
            p.setCenter(this.proposalList);
            p.setRight((Node)this.documentationView);
            this.stage.getScene().setRoot((Parent)p);
            this.stage.focusedProperty().addListener(o -> {
                if (this.stage != null && !this.stage.isFocused()) {
                    Platform.runLater(() -> ((PopupWindow)this.stage).hide());
                }
            });
            this.stage.setOnHidden(o -> {
                this.stage = null;
            });
        }
    }

    @Override
    public boolean verifyKey(VerifyEvent event) {
        System.err.println("CONTENT PROPOSAL POPUP: VerifyEvent " + event);
        return true;
    }
}

