/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.base;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fx.ui.workbench.renderers.base.BaseRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WLayoutedWidget;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WPlaceholderWidget;
import org.eclipse.jdt.annotation.NonNull;
import org.osgi.service.event.Event;

public abstract class BasePlaceholderRenderer<N>
extends BaseRenderer<MPlaceholder, WPlaceholderWidget> {
    @Inject
    @Named(value="EFX.RENDERING.SHARED_ELEMENTS_MAP")
    private Map<MUIElement, Set<@NonNull MPlaceholder>> renderedMap;

    private Set<@NonNull MPlaceholder> getRenderedPlaceholders(MUIElement element) {
        Set<@NonNull MPlaceholder> set = this.renderedMap.get(element);
        if (set == null) {
            set = new HashSet<MPlaceholder>();
            this.renderedMap.put(element, set);
        }
        return set;
    }

    @PostConstruct
    void init(@NonNull IEventBroker eventBroker) {
        eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UILabel/iconURI/*", this::handleRefEvent);
        eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UILabel/label/*", this::handleRefEvent);
        eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UILabel/localizedLabel/*", this::handleRefEvent);
        eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UILabel/tooltip/*", this::handleRefEvent);
        eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UILabel/localizedTooltip/*", this::handleRefEvent);
        eventBroker.subscribe("org/eclipse/e4/ui/model/ui/Dirtyable/dirty/*", this::handleRefEvent);
    }

    @Override
    protected void initContext(@NonNull EObject eo, @NonNull IEclipseContext context) {
        MPlaceholder element;
        Set<MPlaceholder> set;
        super.initContext(eo, context);
        if (eo instanceof MPlaceholder && !(set = this.getRenderedPlaceholders((element = (MPlaceholder)eo).getRef())).contains(element)) {
            set.add(element);
        }
    }

    private void handleRefEvent(Event event) {
        Object changedObj = event.getProperty("ChangedElement");
        MUIElement e = (MUIElement)changedObj;
        if (e == null) {
            return;
        }
        if (this.inContextModification(e)) {
            return;
        }
        String attributeName = event.getProperty("AttName").toString();
        Object newValue = event.getProperty("NewValue");
        for (MPlaceholder p : this.getRenderedPlaceholders(e)) {
            try {
                IEclipseContext ctx;
                this.contextModification.put(p, Boolean.TRUE);
                if (!this.isRenderer((MUIElement)p) || (ctx = this.getRenderingContext((MUIElement)p)) == null) continue;
                ctx.set(attributeName, newValue);
            }
            finally {
                this.contextModification.put(p, Boolean.FALSE);
            }
        }
    }

    @Override
    protected void initWidget(MPlaceholder element, WPlaceholderWidget widget) {
        WLayoutedWidget refWidget;
        super.initWidget(element, widget);
        MUIElement ref = element.getRef();
        ref.setCurSharedRef(element);
        Set<MPlaceholder> set = this.getRenderedPlaceholders(ref);
        if (!set.contains(element)) {
            set.add(element);
        }
        if ((refWidget = (WLayoutedWidget)ref.getWidget()) == null) {
            ref.setToBeRendered(true);
            IEclipseContext contextForParent = this.getContextForParent(ref);
            if (contextForParent != null) {
                refWidget = (WLayoutedWidget)this.engineCreateWidget(ref, contextForParent);
            } else {
                this.getLogger().error("Could not find context for reference '" + ref + "'");
            }
        }
        widget.setContent(refWidget);
        if (ref instanceof MContext) {
            IEclipseContext context = ((MContext)ref).getContext();
            IEclipseContext newParentContext = this.getModelContext((MUIElement)element);
            if (context.getParent() != newParentContext) {
                context.setParent(newParentContext);
            }
        }
    }

    @Override
    public void destroyWidget(MPlaceholder element) {
        MUIElement refElement = element.getRef();
        Set<MPlaceholder> set = this.renderedMap.get(refElement);
        if (set != null) {
            set.remove(element);
        }
        if (set == null || set.isEmpty()) {
            if (refElement instanceof MPart) {
                MPart thePart = (MPart)refElement;
                String imageURI = thePart.getIconURI();
                thePart.setIconURI(null);
                thePart.setIconURI(imageURI);
            }
            this.getPresentationEngine().removeGui(refElement);
        } else {
            IEclipseContext curContext = this.modelService.getContainingContext((MUIElement)element);
            MPlaceholder currentRef = refElement.getCurSharedRef();
            IEclipseContext newParentContext = this.modelService.getContainingContext((MUIElement)currentRef);
            List allContexts = this.modelService.findElements(refElement, null, MContext.class, null);
            for (MContext ctxtElement : allContexts) {
                IEclipseContext theContext = ctxtElement.getContext();
                if (theContext == null || theContext.getParent() != curContext) continue;
                if (curContext.getActiveChild() == theContext) {
                    theContext.deactivate();
                }
                theContext.setParent(newParentContext);
            }
        }
        super.destroyWidget(element);
    }

    @Override
    protected void doProcessContent(MPlaceholder element) {
    }

    public void childRendered(MPlaceholder parentElement, MUIElement element) {
    }

    public void hideChild(MPlaceholder container, MUIElement changedObj) {
    }
}

