/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.log;

import java.util.logging.Level;
import javax.inject.Provider;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.core.log.LoggerFactory;

public class JUtilLoggerFactory
implements LoggerFactory,
Provider<LoggerFactory> {
    public LoggerFactory get() {
        return this;
    }

    @Override
    public Logger createLogger(String name) {
        return new LoggerImpl(name);
    }

    static class LoggerImpl
    implements Logger {
        private java.util.logging.Logger logger;
        private String name;

        public LoggerImpl(String name) {
            this.name = name;
        }

        private java.util.logging.Logger getLogger() {
            if (this.logger == null) {
                this.logger = java.util.logging.Logger.getLogger(this.name);
            }
            return this.logger;
        }

        private static Level toLogLevel(Logger.Level level) {
            switch (level) {
                case TRACE: {
                    return Level.FINEST;
                }
                case DEBUG: {
                    return Level.FINE;
                }
                case INFO: {
                    return Level.INFO;
                }
                case WARNING: {
                    return Level.WARNING;
                }
                case ERROR: {
                    return Level.SEVERE;
                }
                case FATAL: {
                    return Level.SEVERE;
                }
            }
            return Level.SEVERE;
        }

        private void logInternal(Logger.Level level, String message, Throwable t) {
            Level jlevel = LoggerImpl.toLogLevel(level);
            StackTraceElement frame = null;
            StackTraceElement[] e = Thread.currentThread().getStackTrace();
            if (e.length > 2) {
                int i = 2;
                while (i < e.length) {
                    if (!this.getClass().getName().equals(e[i].getClassName())) {
                        frame = e[i];
                        break;
                    }
                    ++i;
                }
            }
            if (t == null) {
                if (frame != null) {
                    this.getLogger().logp(jlevel, frame.getClassName(), frame.getMethodName(), message);
                } else {
                    this.getLogger().log(jlevel, message);
                }
            } else if (frame != null) {
                this.getLogger().logp(jlevel, frame.getClassName(), frame.getMethodName(), message, t);
            } else {
                this.getLogger().log(jlevel, message, t);
            }
        }

        @Override
        public void log(Logger.Level level, String message) {
            if (!this.isEnabled(level)) {
                return;
            }
            this.logInternal(level, message, null);
        }

        @Override
        public void logf(Logger.Level level, String pattern, Throwable t, Object ... args) {
            if (!this.isEnabled(level)) {
                return;
            }
            this.logInternal(level, String.format(pattern, args), t);
        }

        @Override
        public void logf(Logger.Level level, String pattern, Object ... args) {
            if (!this.isEnabled(level)) {
                return;
            }
            this.logInternal(level, String.format(pattern, args), null);
        }

        @Override
        public void log(Logger.Level level, String message, Throwable t) {
            if (!this.isEnabled(level)) {
                return;
            }
            this.logInternal(level, message, t);
        }

        @Override
        public void trace(String message) {
            if (!this.isEnabled(Logger.Level.TRACE)) {
                return;
            }
            this.logInternal(Logger.Level.TRACE, message, null);
        }

        @Override
        public void trace(String message, Throwable t) {
            if (!this.isEnabled(Logger.Level.TRACE)) {
                return;
            }
            this.logInternal(Logger.Level.TRACE, message, t);
        }

        @Override
        public void debug(String message) {
            if (!this.isEnabled(Logger.Level.DEBUG)) {
                return;
            }
            this.logInternal(Logger.Level.DEBUG, message, null);
        }

        @Override
        public void debug(String message, Throwable t) {
            if (!this.isEnabled(Logger.Level.DEBUG)) {
                return;
            }
            this.logInternal(Logger.Level.DEBUG, message, t);
        }

        @Override
        public void info(String message) {
            if (!this.isEnabled(Logger.Level.INFO)) {
                return;
            }
            this.logInternal(Logger.Level.INFO, message, null);
        }

        @Override
        public void info(String message, Throwable t) {
            if (!this.isEnabled(Logger.Level.INFO)) {
                return;
            }
            this.logInternal(Logger.Level.INFO, message, t);
        }

        @Override
        public void warning(String message) {
            if (!this.isEnabled(Logger.Level.WARNING)) {
                return;
            }
            this.logInternal(Logger.Level.WARNING, message, null);
        }

        @Override
        public void warning(String message, Throwable t) {
            if (!this.isEnabled(Logger.Level.WARNING)) {
                return;
            }
            this.logInternal(Logger.Level.WARNING, message, t);
        }

        @Override
        public void error(String message) {
            if (!this.isEnabled(Logger.Level.ERROR)) {
                return;
            }
            this.logInternal(Logger.Level.ERROR, message, null);
        }

        @Override
        public void error(String message, Throwable t) {
            if (!this.isEnabled(Logger.Level.ERROR)) {
                return;
            }
            this.logInternal(Logger.Level.ERROR, message, t);
        }

        @Override
        public void fatal(String message) {
            if (!this.isEnabled(Logger.Level.FATAL)) {
                return;
            }
            this.logInternal(Logger.Level.FATAL, message, null);
        }

        @Override
        public void fatal(String message, Throwable t) {
            if (!this.isEnabled(Logger.Level.FATAL)) {
                return;
            }
            this.logInternal(Logger.Level.FATAL, message, t);
        }

        @Override
        public void tracef(String pattern, Object ... args) {
            if (!this.isEnabled(Logger.Level.TRACE)) {
                return;
            }
            this.logInternal(Logger.Level.TRACE, String.format(pattern, args), null);
        }

        @Override
        public void tracef(String pattern, Throwable t, Object ... args) {
            if (!this.isEnabled(Logger.Level.TRACE)) {
                return;
            }
            this.logInternal(Logger.Level.TRACE, String.format(pattern, args), t);
        }

        @Override
        public void debugf(String pattern, Object ... args) {
            if (!this.isEnabled(Logger.Level.DEBUG)) {
                return;
            }
            this.logInternal(Logger.Level.DEBUG, String.format(pattern, args), null);
        }

        @Override
        public void debugf(String pattern, Throwable t, Object ... args) {
            if (!this.isEnabled(Logger.Level.DEBUG)) {
                return;
            }
            this.logInternal(Logger.Level.DEBUG, String.format(pattern, args), t);
        }

        @Override
        public void infof(String pattern, Object ... args) {
            if (!this.isEnabled(Logger.Level.INFO)) {
                return;
            }
            this.logInternal(Logger.Level.INFO, String.format(pattern, args), null);
        }

        @Override
        public void infof(String pattern, Throwable t, Object ... args) {
            if (!this.isEnabled(Logger.Level.INFO)) {
                return;
            }
            this.logInternal(Logger.Level.INFO, String.format(pattern, args), t);
        }

        @Override
        public void warningf(String pattern, Object ... args) {
            if (!this.isEnabled(Logger.Level.WARNING)) {
                return;
            }
            this.logInternal(Logger.Level.WARNING, String.format(pattern, args), null);
        }

        @Override
        public void warningf(String pattern, Throwable t, Object ... args) {
            if (!this.isEnabled(Logger.Level.WARNING)) {
                return;
            }
            this.logInternal(Logger.Level.WARNING, String.format(pattern, args), t);
        }

        @Override
        public void errorf(String pattern, Object ... args) {
            if (!this.isEnabled(Logger.Level.ERROR)) {
                return;
            }
            this.logInternal(Logger.Level.ERROR, String.format(pattern, args), null);
        }

        @Override
        public void errorf(String pattern, Throwable t, Object ... args) {
            if (!this.isEnabled(Logger.Level.ERROR)) {
                return;
            }
            this.logInternal(Logger.Level.ERROR, String.format(pattern, args), t);
        }

        @Override
        public void fatalf(String pattern, Object ... args) {
            if (!this.isEnabled(Logger.Level.FATAL)) {
                return;
            }
            this.logInternal(Logger.Level.FATAL, String.format(pattern, args), null);
        }

        @Override
        public void fatalf(String pattern, Throwable t, Object ... args) {
            if (!this.isEnabled(Logger.Level.FATAL)) {
                return;
            }
            this.logInternal(Logger.Level.FATAL, String.format(pattern, args), t);
        }

        @Override
        public boolean isEnabled(Logger.Level level) {
            return this.getLogger().isLoggable(LoggerImpl.toLogLevel(level));
        }
    }
}

