/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.javart.services.servlet.proxy;

import eglx.http.Request;
import eglx.http.Response;
import eglx.json.JsonUtilities;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.edt.javart.services.ServiceUtilities;
import org.eclipse.edt.javart.services.servlet.Servlet;
import org.eclipse.edt.javart.services.servlet.ServletUtilities;
import org.eclipse.edt.javart.services.servlet.proxy.ProxyEventHandler;

public class AjaxProxyServlet
extends Servlet {
    private static final long serialVersionUID = 10L;
    private static final String PROXY_SERVLET = "EGL Rich UI Proxy";

    @Override
    protected String servletName() {
        return PROXY_SERVLET;
    }

    @Override
    protected Response processRequest(String url, Request ruiRequest, HttpServletRequest httpServletReq) throws Exception {
        ProxyEventHandler proxy = new ProxyEventHandler();
        return proxy.runProxy(url, ruiRequest, ServletUtilities.createHttpRequest(ruiRequest.body));
    }

    @Override
    protected void sendResponse(HttpServletResponse httpServletRes, int status, String content) throws IOException {
        if (status != 200) {
            try {
                httpServletRes.setHeader(JsonUtilities.JSON_RPC_ERROR_NAME_VALUE, URLEncoder.encode(content, ServiceUtilities.UTF8));
            }
            catch (Exception exception) {}
        }
        PrintWriter pw = httpServletRes.getWriter();
        pw.write(content);
        pw.flush();
        httpServletRes.setStatus(status);
        httpServletRes.flushBuffer();
    }
}

