/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.connectors.http.adapters;

import java.net.URI;
import java.util.Map;
import org.eclipse.ebpm.connectors.http.adapters.IHTTPOutputProtocolAdapter;
import org.eclipse.ebpm.connectors.http.adapters.SpagicJettyHTTPExchange;
import org.eclipse.ebpm.core.ExchangeUtils;
import org.eclipse.ebpm.messaging.api.Exchange;
import org.eclipse.ebpm.messaging.api.Message;
import org.eclipse.ebpm.messaging.api.Pattern;
import org.eclipse.ebpm.messaging.api.Status;
import org.eclipse.ebpm.util.properties.PropertyConfigurator;
import org.eclipse.jetty.http.HttpHeaders;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;

public class PlainHTTPOutputProtocolAdapter
implements IHTTPOutputProtocolAdapter {
    private String DEFAULT_CONTENT_TYPE = "text/xml";

    @Override
    public String getAdapterId() {
        return "PlainHTTP";
    }

    protected String getLocationUri(Exchange exchange, Message inMsg, PropertyConfigurator pc) {
        if (inMsg.getHeader("locationURI") != null) {
            return (String)inMsg.getHeader("locationURI");
        }
        return pc.getString("locationURI");
    }

    protected String getMethod(Exchange exchange, Message inMsg, PropertyConfigurator pc) {
        if (inMsg.getHeader("method") != null) {
            return (String)inMsg.getHeader("method");
        }
        return pc.getString("method", null);
    }

    protected String getContentType(Exchange exchange, Message inMsg, PropertyConfigurator pc) {
        if (inMsg.getHeader("content-type") != null) {
            return (String)inMsg.getHeader("content-type");
        }
        return pc.getString("content-type", this.DEFAULT_CONTENT_TYPE);
    }

    @Override
    public void fillJettyExchange(Exchange exchange, SpagicJettyHTTPExchange httpExchange, PropertyConfigurator pc, Object binding) {
        try {
            Message inMsg = exchange.getIn(false);
            httpExchange.setURL(this.getLocationUri(exchange, inMsg, pc));
            httpExchange.addRequestHeader(HttpHeaders.HOST_BUFFER, (Buffer)new ByteArrayBuffer(new URI(this.getLocationUri(exchange, inMsg, pc)).getHost()));
            httpExchange.setMethod(this.getMethod(exchange, inMsg, pc));
            httpExchange.setRequestHeader("Content-Type", this.getContentType(exchange, inMsg, pc));
            if (inMsg.getBody() != null) {
                byte[] byteBuffer = inMsg.getBodyText().getBytes();
                httpExchange.setRequestContent((Buffer)new ByteArrayBuffer(byteBuffer));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void handleResponse(Exchange exchange, SpagicJettyHTTPExchange httpExchange, PropertyConfigurator pc, Object binding) {
        try {
            int response = httpExchange.getResponseStatus();
            if (response != 200 && response != 202) {
                if (pc.getBoolean("isSendFaultsToTarget", Boolean.valueOf(false)).booleanValue()) {
                    if (exchange.getPattern() == Pattern.InOnly) {
                        this.handleException(exchange, httpExchange, new Exception("Invalid status response: " + response), pc, binding);
                    }
                    if (exchange.getPattern() == Pattern.InOut) {
                        byte[] responze = httpExchange.getResponse();
                        Message out = exchange.getOut();
                        out.setBody("<ERROR>" + (responze != null ? new String(responze) : "") + "</ERROR>");
                        exchange.setOut(out);
                    }
                } else {
                    if (exchange.getPattern() == Pattern.InOnly) {
                        exchange.setError(new Exception("Invalid status response: " + response));
                    }
                    if (exchange.getPattern() == Pattern.InOut) {
                        Message fault = exchange.getFault(true);
                        byte[] responze = httpExchange.getResponse();
                        fault.setBody(responze != null ? new String(responze) : "");
                        exchange.setFault(fault);
                    }
                }
            } else if (exchange.getPattern() == Pattern.InOut) {
                Message out = exchange.getOut();
                out.setBody(new String(httpExchange.getResponse()));
                exchange.setOut(out);
            } else {
                exchange.setStatus(Status.Done);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void handleException(Exchange exchange, SpagicJettyHTTPExchange httpExchange, Throwable ex, PropertyConfigurator pc, Object binding) {
        if (pc.getBoolean("isSendFaultsToTarget", Boolean.valueOf(false)).booleanValue()) {
            Message out = exchange.getOut(true);
            out.setBody("<ERROR>" + new String(ExchangeUtils.getStringFromException((Throwable)ex)) + "</ERROR>");
            exchange.setOut(out);
        } else {
            exchange.setError((Exception)ex);
        }
    }

    @Override
    public void setProperty(Map<String, String> map) {
    }
}

