/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.attachments;

import org.eclipse.ebpm.attachments.AttachmentsActivator;
import org.eclipse.ebpm.attachments.IAttachmentStore;
import org.eclipse.ebpm.attachments.db.DBAttachmentStore;
import org.eclipse.ebpm.attachments.fs.FileSystemAttachmentStore;

public class AttachmentStoreManager {
    public static IAttachmentStore getAttachmentStore() {
        return AttachmentStoreManager.getIdentifiedAttachmentStore(AttachmentStoreManager.getAttachmentStoreId());
    }

    private static String getAttachmentStoreId() {
        String configured = System.getProperty("spagic.attachment.store");
        if (configured == null) {
            configured = "fs";
        }
        return configured;
    }

    private static IAttachmentStore getIdentifiedAttachmentStore(String name) {
        if (name.equalsIgnoreCase("db")) {
            try {
                return new DBAttachmentStore(AttachmentsActivator.getDataSourceManager().getDataSource("attachments"));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return new FileSystemAttachmentStore();
    }
}

