/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.serviceregistration;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.ebpm.databasemanager.IDatabaseManager;
import org.eclipse.ebpm.metadb.model.Service;
import org.eclipse.ebpm.service.model.IServiceModelHelper;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicRegistrationService {
    protected Logger log = LoggerFactory.getLogger(DynamicRegistrationService.class);
    private AtomicReference<IDatabaseManager> databaseManager = new AtomicReference();
    private AtomicReference<IServiceModelHelper> serviceModelHelper = new AtomicReference();
    private ConcurrentHashMap<String, HashMap<String, HashMap<String, String>>> pendingRegistrations = new ConcurrentHashMap();
    public static final List<String> SERVICE_TRANSIENT_PROPERTIES = Arrays.asList("factory.name", "SPAGIC_TYPE", "event.topics");

    public void addService(ServiceReference reference) {
        String serviceId = (String)reference.getProperty("spagic.id");
        String factoryName = (String)reference.getProperty("factory.name");
        this.log.debug("Checking service: " + serviceId);
        if (factoryName == null) {
            return;
        }
        HashMap<String, String> properties = new HashMap<String, String>(reference.getPropertyKeys().length);
        String[] stringArray = reference.getPropertyKeys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String propKey = stringArray[n2];
            Object propValue = reference.getProperty(propKey);
            this.log.debug(String.valueOf(propKey) + "=" + propValue);
            if (propValue instanceof String && !SERVICE_TRANSIENT_PROPERTIES.contains(propKey)) {
                properties.put(propKey, (String)propValue);
            }
            ++n2;
        }
        String componentName = this.getServiceModelHelper().getComponentName(factoryName);
        this.log.debug("Component name: " + componentName);
        if (componentName != null && componentName.length() != 0) {
            this.registerServiceInDatabase(componentName, serviceId, properties);
        }
    }

    private void registerServiceInDatabase(String componentName, String serviceId, HashMap<String, String> properties) {
        Service service = this.getDbManager().registerService(serviceId, componentName, properties);
        if (service == null) {
            this.log.warn("Service Not Registered because component [" + componentName + "] is not on database");
            this.log.warn("Put this on pending deployment for component[" + componentName + "]");
            if (this.pendingRegistrations.get(componentName) == null) {
                this.pendingRegistrations.put(componentName, new HashMap());
            }
            this.pendingRegistrations.get(componentName).put(serviceId, properties);
        }
    }

    public void removeService(ServiceReference reference) {
    }

    public void addComponent(ServiceReference reference) {
        String componentFactory = (String)reference.getProperty("component.factory");
        this.log.info("Checking component factory: " + componentFactory);
        if (componentFactory == null) {
            return;
        }
        HashMap<String, String> properties = new HashMap<String, String>(reference.getPropertyKeys().length);
        String[] stringArray = reference.getPropertyKeys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String propKey = stringArray[n2];
            Object propValue = reference.getProperty(propKey);
            this.log.debug("#### " + propKey + "=" + propValue);
            if (propValue instanceof String) {
                properties.put(propKey, (String)propValue);
            }
            ++n2;
        }
        String componentName = this.getServiceModelHelper().getComponentName(componentFactory);
        String componentType = this.getServiceModelHelper().getComponentType(componentFactory);
        if (componentName != null && componentName.length() != 0) {
            this.getDbManager().registerComponent(componentName, componentType, properties);
        }
        this.log.info("Revamp Pending Registration for component [" + componentName + "]");
        HashMap<String, HashMap<String, String>> pendingRegistrationForComponent = this.pendingRegistrations.remove(componentName);
        if (pendingRegistrationForComponent != null) {
            for (String serviceId : pendingRegistrationForComponent.keySet()) {
                this.registerServiceInDatabase(componentName, serviceId, pendingRegistrationForComponent.get(serviceId));
            }
        }
    }

    public void removeComponent(ServiceReference reference) {
    }

    public IDatabaseManager getDbManager() {
        return this.databaseManager.get();
    }

    public IServiceModelHelper getServiceModelHelper() {
        return this.serviceModelHelper.get();
    }

    public void bindDatabaseManager(IDatabaseManager dbManager) {
        this.databaseManager.set(dbManager);
    }

    public void unbindDatabaseManager(IDatabaseManager dbManager) {
        this.databaseManager.compareAndSet(dbManager, null);
    }

    public void bindServiceModelHelper(IServiceModelHelper serviceModelHelper) {
        this.serviceModelHelper.set(serviceModelHelper);
    }

    public void unbindServiceModelHelper(IServiceModelHelper serviceModelHelper) {
        this.serviceModelHelper.compareAndSet(serviceModelHelper, null);
    }
}

