/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.adapters.log;

import java.io.File;
import org.eclipse.ebam.adapters.IAdapterManager;
import org.eclipse.ebam.adapters.log.Reader;
import org.eclipse.ebam.adapters.utils.FilesContainer;
import org.eclipse.ebam.adapters.utils.LineAnalyzer;
import org.eclipse.ebam.messages.EbamMessage;
import org.eclipse.ebam.messages.IEbamMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileMonitor {
    private static final int RECOVERY = 1;
    private static final int APPEND = 2;
    private static final int SEND = 3;
    private static final int FOUND = 4;
    private int state = 3;
    private static long PAUSE_INTERVAL_VALUE = 500L;
    private EbamMessage message = null;
    private IAdapterManager manager = null;
    private String adapterId = null;
    private boolean keyMode = true;
    private boolean appendMode = false;
    private String fileNameFromKey = null;
    private boolean stop = false;
    private FilesContainer filesContainer = null;
    private String directory = null;
    private static Logger logger = LoggerFactory.getLogger(FileMonitor.class);

    public FileMonitor(String adapId, String directory, String fileNameRoot, boolean keyMode, boolean appendMode, IAdapterManager man, String fileNameFromKey) {
        logger.info("IN: Starting fileMonitor with parameters adapId = " + adapId + "; directory = " + directory + "; fileNameRoot = " + fileNameRoot + "; keyMode=" + keyMode + "; " + " appendMode = " + appendMode + " fileNameFromKey = " + fileNameFromKey);
        this.manager = man;
        this.adapterId = adapId;
        this.directory = directory;
        this.keyMode = keyMode;
        this.appendMode = appendMode;
        this.fileNameFromKey = fileNameFromKey;
        this.filesContainer = new FilesContainer(directory, fileNameRoot);
    }

    public final void monitorFile(String fromKey) {
        logger.debug("IN: Starting fileMonitor with parameters fromKey = " + fromKey);
        if (this.keyMode && fromKey != null) {
            this.state = 1;
        }
        if (this.appendMode) {
            logger.info("appendMode==true... send=false");
            this.state = 2;
        }
        String actualFile = null;
        boolean foundFile = false;
        if (this.state == 1 && this.fileNameFromKey != null) {
            logger.debug("modality is recovering and file where to read the key is " + this.fileNameFromKey);
            actualFile = this.getFileWhereKeyWasFound();
            if (actualFile != null) {
                foundFile = true;
                logger.debug("file " + this.fileNameFromKey + " has been found");
            } else {
                logger.debug("file " + this.fileNameFromKey + " not found, go on from first");
            }
        }
        if (!foundFile) {
            logger.debug("get first file to read");
            actualFile = this.getFirstFileToRead(this.appendMode);
        }
        logger.debug("Reading file (actualFile) " + actualFile);
        Reader reader = new Reader(this.directory, actualFile);
        this.readCycle(reader, fromKey);
    }

    private void renameFile(Reader reader) {
        logger.debug("IN. Reader = " + reader.getFileName());
        File oldFile = new File(reader.getFullFileName());
        File renameFile = new File(String.valueOf(reader.getFullFileName()) + "_old");
        try {
            oldFile.renameTo(renameFile);
        }
        catch (Exception e) {
            logger.error("Error during rename File", (Throwable)e);
        }
    }

    private void readCycle(Reader reader, String fromKey) {
        logger.debug("IN with parameters fromKey = " + fromKey + " and Reader = " + reader.getFileName());
        while (!this.isStop()) {
            Object[] msgs = reader.getNext();
            if (msgs == null) {
                logger.debug("No new messages read from file " + reader.getFileName() + " check if a newer file exists");
                File newFile = this.filesContainer.getNextFile(reader.getFileName());
                if (newFile != null) {
                    logger.debug("Found a newer file after " + reader.getFileName() + ": " + newFile.getName());
                    this.renameFile(reader);
                    reader = new Reader(this.directory, newFile.getName());
                    logger.debug("Reading file(continue) " + reader.getFileName());
                    continue;
                }
                if (this.state == 2 || this.state == 1) {
                    logger.debug("From append mode pass to writing mode");
                    this.state = 3;
                }
                logger.debug("Sleep waiting for messages");
                this.handleControledSleep();
                continue;
            }
            logger.debug("some message read from file: " + reader.getFileName());
            boolean finished = false;
            int i = 0;
            while (i < msgs.length && !finished) {
                if (msgs[i] != null) {
                    String line = msgs[i].toString();
                    logger.info("line=" + line);
                    if (!line.trim().equalsIgnoreCase("")) {
                        String key = null;
                        if (this.keyMode) {
                            key = LineAnalyzer.isAKeyLine(line);
                            logger.info("key=" + key);
                        }
                        try {
                            this.processSingleLine(line, key, fromKey, reader);
                        }
                        catch (Exception e) {
                            logger.error(e.getMessage());
                        }
                    }
                } else {
                    finished = true;
                    logger.debug("finished = true");
                }
                ++i;
            }
        }
    }

    private String getFirstFileToRead(boolean appendMode) {
        logger.debug("IN");
        File firstFile = null;
        while (firstFile == null) {
            if (this.state == 2) {
                firstFile = this.filesContainer.getLastFile();
                logger.debug("append mode: get directly last file: " + (firstFile != null ? firstFile.getName() : "not found"));
            } else {
                firstFile = this.filesContainer.getFirstFile();
                logger.debug("Normal or recovery mode: get first file: " + (firstFile != null ? firstFile.getName() : "not found"));
            }
            if (firstFile != null) continue;
            if (this.state == 2 || this.state == 1) {
                logger.debug("From append mode pass to sending mode");
                this.state = 3;
            }
            try {
                logger.debug("No file found, sleep for a while.... ");
                Thread.sleep(PAUSE_INTERVAL_VALUE);
            }
            catch (InterruptedException interruptedException) {
                logger.debug("Error");
            }
        }
        logger.debug("OUT");
        return firstFile.getName();
    }

    private String getFileWhereKeyWasFound() {
        logger.debug("IN");
        String toReturn = null;
        File firstFile = this.filesContainer.getFileWhereKeyWasFound(this.fileNameFromKey);
        if (firstFile != null) {
            logger.debug("file " + firstFile + " is found");
            toReturn = firstFile.getName();
        } else {
            logger.debug("file " + firstFile + " NOT found");
        }
        logger.debug("OUT");
        return toReturn;
    }

    private void processSingleLine(String line, String key, String fromKey, Reader reader) throws Exception {
        String xmlRoot;
        logger.debug("IN with parameters line=" + line + " key=" + key + "  fromKey=" + fromKey + "STATE= " + this.state);
        if (this.message == null || key != null) {
            if (this.state == 4) {
                logger.debug("State==FOUND");
                this.state = 3;
            }
            if (this.state == 1 && this.keyMode && key.equals(fromKey)) {
                logger.debug("found key = " + fromKey + " in file ??????");
                this.state = 4;
            }
            this.message = new EbamMessage();
            logger.debug("registering from file " + reader.getFileName());
            this.message.setSource(this.adapterId);
            this.message.setFileName(reader.getFileName());
            this.message.setKey(key);
            if (this.keyMode) {
                line = line.replace("KEY=" + key + ";", "");
            }
            this.message.setMsg(line);
            logger.info("Add line ti message: " + line);
            logger.info("Created new message with KEY:" + key);
        } else {
            logger.debug("This is NOT the first line of message");
            this.message.setMsg(String.valueOf(this.message.getMsg()) + line);
            logger.info("Add line to message: " + line);
            boolean msgEnd = LineAnalyzer.isMessageEnd(line, this.message.getRoot());
            logger.debug("msgEnd: " + msgEnd);
            if (msgEnd) {
                logger.debug("STATE=" + this.state);
                if (this.state == 3 && !this.isStop()) {
                    logger.info("Send message after msgEnd found: " + this.message.getMsg());
                    this.manager.sendToManager((IEbamMessage)this.message);
                } else {
                    logger.debug("The message is finisched but eBAM don't send");
                }
                this.message = null;
            }
        }
        if (this.message != null && this.message.getRoot() == null && (xmlRoot = LineAnalyzer.getXmlRoot(line)) != null) {
            logger.debug("setting xmlRoot : " + xmlRoot);
            this.message.setRoot(xmlRoot);
        }
        logger.debug("OUT");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void handleControledSleep() {
        try {
            FileMonitor fileMonitor = this;
            synchronized (fileMonitor) {
                Thread.sleep(PAUSE_INTERVAL_VALUE);
            }
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
            e.printStackTrace();
        }
    }

    public synchronized boolean isStop() {
        return this.stop;
    }

    public synchronized void setStop(boolean stop) {
        this.stop = stop;
    }
}

