/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.eventmanager.manager;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.eclipse.ebam.emf.interfaces.IAlarmTransactions;
import org.eclipse.ebam.eventmanager.EventManagerConfiguration;
import org.eclipse.ebam.eventmanager.manager.AlertSendingItem;
import org.eclipse.ebam.eventmanager.manager.SMTPAuthenticator;
import org.eclipse.ebam.eventmanager.manager.SaveInfo;
import org.eclipse.ebam.model.entities.SbiAlarm;
import org.eclipse.ebam.model.entities.SbiAlarmContact;
import org.eclipse.ebam.model.entities.SbiAlarmEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendAlarmThread
implements Runnable {
    private Logger logger = LoggerFactory.getLogger(SendAlarmThread.class);
    private final String defaultTimeOut = "10000";
    private static EventManagerConfiguration config = EventManagerConfiguration.getInstance();
    private IAlarmTransactions alarmTransactions = null;

    public SendAlarmThread(IAlarmTransactions a) {
        this.alarmTransactions = a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String launch = config.getLaunchThread();
        if (launch.equalsIgnoreCase("true")) {
            String timeoutConf = config.getTimeoutConf();
            Long timeOut = new Long("10000");
            if (timeoutConf != null && !timeoutConf.equals("")) {
                timeOut = new Long(timeoutConf);
            }
            while (true) {
                this.execute();
                try {
                    SendAlarmThread sendAlarmThread = this;
                    synchronized (sendAlarmThread) {
                        this.wait(timeOut);
                        continue;
                    }
                }
                catch (InterruptedException e) {
                    this.logger.error("Interrupted Exception", (Throwable)e);
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    public void execute() {
        block21: {
            this.logger.debug("IN");
            HashMap<SbiAlarmContact, List<AlertSendingItem>> alertSendingSessionMap = new HashMap<SbiAlarmContact, List<AlertSendingItem>>();
            ArrayList<AlertSendingItem> alertSendingSessionList = null;
            AlertSendingItem alertSendingItem = null;
            List activeSbiAlarmEventList = null;
            SbiAlarm sbiAlarm = null;
            try {
                try {
                    if (this.alarmTransactions == null) break block21;
                    activeSbiAlarmEventList = this.alarmTransactions.alarmTransactionFindActiveAlarmEvents();
                    for (SbiAlarmEvent sbiAlarmEvent : activeSbiAlarmEventList) {
                        if (this.logger.isInfoEnabled()) {
                            this.logger.info("Found AlarmEvent: " + sbiAlarmEvent.getKpiName());
                        }
                        sbiAlarm = sbiAlarmEvent.getSbiAlarm();
                        String resource = sbiAlarmEvent.getResources();
                        alertSendingItem = new AlertSendingItem(sbiAlarm, sbiAlarmEvent);
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Created AlertSendingItem: " + alertSendingItem);
                        }
                        ArrayList<SbiAlarmContact> sbiAlarmContactList = new ArrayList<SbiAlarmContact>();
                        ArrayList associatedContactList = new ArrayList(sbiAlarm.getSbiAlarmContacts());
                        if (resource != null) {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug("Resource enhanced: " + resource);
                            }
                            for (SbiAlarmContact associatedContact : associatedContactList) {
                                if (!resource.equals(associatedContact.getResources()) && associatedContact.getResources() != null) continue;
                                sbiAlarmContactList.add(associatedContact);
                                if (!this.logger.isDebugEnabled()) continue;
                                this.logger.debug("Contact '" + associatedContact + "' added.");
                            }
                        } else {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug("Resource not enhanced.");
                            }
                            for (SbiAlarmContact associatedContact : associatedContactList) {
                                if (associatedContact.getResources() != null) continue;
                                sbiAlarmContactList.add(associatedContact);
                                if (!this.logger.isDebugEnabled()) continue;
                                this.logger.debug("Contact '" + associatedContact + "' added.");
                            }
                        }
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Distribution list: " + sbiAlarmContactList + "\n");
                        }
                        for (SbiAlarmContact sbiAlarmContact : sbiAlarmContactList) {
                            alertSendingSessionList = (ArrayList<AlertSendingItem>)alertSendingSessionMap.get(sbiAlarmContact);
                            if (alertSendingSessionList == null) {
                                if (this.logger.isDebugEnabled()) {
                                    this.logger.debug("alertSendingSessionList null");
                                }
                                alertSendingSessionList = new ArrayList<AlertSendingItem>();
                            }
                            alertSendingSessionList.add(alertSendingItem);
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug("Contact '" + sbiAlarmContact.getName() + "' added to alertSendingSessionList.");
                            }
                            alertSendingSessionMap.put(sbiAlarmContact, alertSendingSessionList);
                        }
                        boolean autoDisabled = true;
                        if (sbiAlarm.getAutoDisabled() != null && sbiAlarm.getAutoDisabled().equalsIgnoreCase("F")) {
                            autoDisabled = false;
                        }
                        if (!autoDisabled) continue;
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Single alarm '" + sbiAlarm.getLabel() + "' disabled.");
                        }
                        sbiAlarmEvent.setActive("F");
                        this.alarmTransactions.alarmTransactionUpdateSbiAlarmEvent(sbiAlarmEvent);
                    }
                    this.startEmailSession(alertSendingSessionMap);
                }
                catch (Throwable e) {
                    this.logger.error("Error while executiong job ", e);
                    e.printStackTrace();
                    this.logger.debug("OUT");
                }
            }
            finally {
                this.logger.debug("OUT");
            }
        }
    }

    private void startEmailSession(Map<SbiAlarmContact, List<AlertSendingItem>> alertSendingSessionMap) {
        this.logger.debug("IN");
        Set<SbiAlarmContact> keySet = alertSendingSessionMap.keySet();
        SaveInfo sInfo = new SaveInfo();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Distribution list parsing.");
        }
        for (SbiAlarmContact sbiAlarmContact : keySet) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Found contact '" + sbiAlarmContact.getName() + "'.");
            }
            List<AlertSendingItem> alertSendingList = alertSendingSessionMap.get(sbiAlarmContact);
            SbiAlarm sbiAlarm = null;
            SbiAlarmEvent sbiAlarmEvent = null;
            StringBuffer subject = new StringBuffer();
            StringBuffer text = new StringBuffer();
            for (AlertSendingItem alertSendingItem : alertSendingList) {
                sbiAlarm = alertSendingItem.getSbiAlarm();
                sbiAlarmEvent = alertSendingItem.getSbiAlarmEvent();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Found alarm " + sbiAlarm.getName() + ".");
                }
                subject.append(sbiAlarm.getLabel());
                text.append("<font size=\"4\">Allarme </font><font color=\"red\" size=\"4\"><b>");
                text.append(sbiAlarm.getName());
                text.append("</b></font><ul>");
                text.append("<li><font size=\"2\">Lable: ");
                text.append(sbiAlarm.getLabel());
                text.append("</font></li>");
                text.append("<li><font size=\"2\">Text: ");
                text.append(sbiAlarm.getText());
                text.append("</font></li>");
                text.append("<li><font size=\"2\">Description: ");
                text.append(sbiAlarm.getDescr());
                text.append("</font></li>");
                text.append("<li><font size=\"2\">Date: ");
                text.append(sbiAlarmEvent.getEventTs());
                text.append("</font></li>");
                text.append("</ul><br>");
                String res = sbiAlarmEvent.getResources();
                if (res != null) {
                    text.append("<li><font size=\"2\">resources:");
                    text.append(res);
                    text.append("</font></li>");
                }
                text.append("</ul><hr width=\"90%\">");
            }
            String link = sbiAlarm.getUrl();
            text.append(link);
            String email = sbiAlarmContact.getEmail();
            if (email != null) {
                sInfo.setEmail(email);
                sInfo.setMailSubj("MGC alarm: " + new Date() + " [" + sbiAlarmContact.getName() + "]");
                sInfo.setMailText(text.toString());
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Sending email to: " + sInfo.getEmail());
            }
            this.sendMail(sInfo, null, null, null);
        }
        this.logger.debug("OUT");
    }

    private void sendMail(SaveInfo sInfo, byte[] response, String retCT, String fileExt) {
        this.logger.debug("IN");
        try {
            try {
                String user;
                String smtphost = config.getSmtphost();
                String smtpport = config.getSmtpport();
                int smptPort = 25;
                if (smtphost == null || smtphost.trim().equals("")) {
                    throw new Exception("Smtp host not configured");
                }
                if (smtpport == null || smtpport.trim().equals("")) {
                    throw new Exception("Smtp host not configured");
                }
                smptPort = Integer.parseInt(smtpport);
                String from = config.getFrom();
                if (from == null || from.trim().equals("")) {
                    from = "spagobi.scheduler@eng.it";
                }
                if ((user = config.getUser()) == null || user.trim().equals("")) {
                    throw new Exception("Smtp user not configured");
                }
                String pass = config.getPass();
                if (pass == null || pass.trim().equals("")) {
                    throw new Exception("Smtp password not configured");
                }
                String mailTos = sInfo.getEmail();
                if (mailTos == null || mailTos.trim().equals("")) {
                    throw new Exception("No recipient address found");
                }
                String mailSubj = sInfo.getMailSubj();
                String mailTxt = sInfo.getMailText();
                String[] recipients = mailTos.split(",");
                Properties props = new Properties();
                props.put("mail.smtp.host", smtphost);
                props.put("mail.smtp.port", (Object)smptPort);
                props.put("mail.smtp.auth", "true");
                SMTPAuthenticator auth = new SMTPAuthenticator(user, pass);
                Session session = Session.getDefaultInstance((Properties)props, (Authenticator)auth);
                MimeMessage msg = new MimeMessage(session);
                InternetAddress addressFrom = new InternetAddress(from);
                msg.setFrom((Address)addressFrom);
                InternetAddress[] addressTo = new InternetAddress[recipients.length];
                int i = 0;
                while (i < recipients.length) {
                    addressTo[i] = new InternetAddress(recipients[i]);
                    ++i;
                }
                msg.setRecipients(Message.RecipientType.TO, (Address[])addressTo);
                String subject = mailSubj;
                msg.setSubject(subject);
                MimeBodyPart mbp1 = new MimeBodyPart();
                mbp1.setText(mailTxt);
                MimeMultipart mp = new MimeMultipart();
                mp.addBodyPart((BodyPart)mbp1);
                msg.setContent((Object)mailTxt, "text/html");
                Transport.send((Message)msg);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error("Error while sending schedule result mail", (Throwable)e);
                this.logger.debug("OUT");
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.logger.error("Error while sending schedule result mail", t);
                this.logger.debug("OUT");
            }
        }
        finally {
            this.logger.debug("OUT");
        }
    }
}

