/*******************************************************************************
 * Copyright (c) 2010 Engineering Group.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Giulio Gavardi (Engineering Group) - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.ebam.emf;

import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.Query;

import org.eclipse.ebam.model.entities.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EbamEventTransactions extends EMF{

	/**
	 * Logger.
	 */
	private static Logger logger = 
		LoggerFactory.getLogger(EbamEventTransactions.class);
	private EntityManager em = null;



	/** Get all ebam events.
	 * 
	 * @return list of alarms
	 * @throws Exception
	 */

	public final List getEbamEventList() throws Exception {
		logger.debug("IN");
		List ebamEvents = null;
		EntityManager em = getEMF().createEntityManager();
		try {
			// remove from cache because could have been changed outside of program
			getEMF().getCache().evict(Event.class);	
			Query query = em.createQuery("select s from "
					+ "Event s");
			ebamEvents = query.getResultList();
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
		} finally {			
			em.close();
		}
		logger.debug("OUT");
		return ebamEvents;
	}



	/** Get all ebam events by event id.
	 * 
	 * @return event by id
	 * @throws Exception
	 */
	public final Event getEbamEventById(Integer ebamEventId) throws Exception {
		logger.debug("IN");
		Event event = null;
		EntityManager em = getEMF().createEntityManager();
		try {
			Query query = em.createQuery("select s from "
					+ "Event s where s.eventId = :id");
			query.setParameter("id", ebamEventId);
			event =(Event) query.getSingleResult();
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
		} finally {			
			em.close();
		}
		logger.debug("OUT");
		return event;
	}


}
