/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Red Hat, Inc. All rights reserved.
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
'use strict';
Object.defineProperty(exports, "__esModule", { value: true });
const arrUtils_1 = require("../utils/arrUtils");
const yamlParser07_1 = require("../parser/yamlParser07");
class YAMLHover {
    constructor(promiseConstructor, jsonLanguageService) {
        this.promise = promiseConstructor || Promise;
        this.shouldHover = true;
        this.jsonLanguageService = jsonLanguageService;
    }
    configure(languageSettings) {
        if (languageSettings) {
            this.shouldHover = languageSettings.hover;
        }
    }
    doHover(document, position) {
        if (!this.shouldHover || !document) {
            return this.promise.resolve(void 0);
        }
        const doc = yamlParser07_1.parse(document.getText());
        const offset = document.offsetAt(position);
        const currentDoc = arrUtils_1.matchOffsetToDocument2(offset, doc);
        if (currentDoc === null) {
            return this.promise.resolve(void 0);
        }
        return this.jsonLanguageService.doHover(document, position, currentDoc);
    }
}
exports.YAMLHover = YAMLHover;
//# sourceMappingURL=yamlHover.js.map