/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.debug;

import java.io.File;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationSelectionDialog;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut2;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wildwebdeveloper.Activator;
import org.eclipse.wildwebdeveloper.debug.SelectionUtils;

public abstract class AbstractDebugAdapterLaunchShortcut
implements ILaunchShortcut2 {
    protected final String launchConfigTypeId;
    protected final String contentTypeId;

    public AbstractDebugAdapterLaunchShortcut(String launchConfigTypeId, String contentTypeId) {
        this.launchConfigTypeId = launchConfigTypeId;
        this.contentTypeId = contentTypeId;
    }

    public boolean canLaunch(File file) {
        return file.exists() && Platform.getContentTypeManager().getContentType(this.contentTypeId).isAssociatedWith(file.getName());
    }

    public ILaunchConfiguration[] getLaunchConfigurations(ISelection selection) {
        IResource launchableResource = this.getLaunchableResource(selection);
        if (launchableResource != null) {
            return this.getLaunchConfigurations(launchableResource.getLocation().toFile());
        }
        return this.getLaunchConfigurations(SelectionUtils.getFile(selection, this::canLaunch));
    }

    public ILaunchConfiguration[] getLaunchConfigurations(IEditorPart editorpart) {
        IResource launchableResource = this.getLaunchableResource(editorpart);
        if (launchableResource != null) {
            return this.getLaunchConfigurations(launchableResource.getLocation().toFile());
        }
        return this.getLaunchConfigurations(SelectionUtils.getFile(editorpart.getEditorInput(), this::canLaunch));
    }

    public IResource getLaunchableResource(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (structuredSelection.size() != 1) {
                return null;
            }
            Object firstObject = structuredSelection.getFirstElement();
            IResource resource = (IResource)Adapters.adapt((Object)firstObject, IResource.class);
            if (this.canLaunch(resource.getLocation().toFile())) {
                return resource;
            }
        }
        return null;
    }

    public IResource getLaunchableResource(IEditorPart editorpart) {
        IFile file;
        IEditorInput input = editorpart.getEditorInput();
        if (input instanceof FileEditorInput && this.canLaunch((file = ((FileEditorInput)input).getFile()).getLocation().toFile())) {
            return file;
        }
        return null;
    }

    public void launch(ISelection selection, String mode) {
        ILaunchConfiguration[] configurations = this.getLaunchConfigurations(selection);
        this.launch(mode, configurations);
    }

    public void launch(IEditorPart editor, String mode) {
        ILaunchConfiguration[] configurations = this.getLaunchConfigurations(editor);
        this.launch(mode, configurations);
    }

    private void launch(String mode, ILaunchConfiguration[] configurations) {
        LaunchConfigurationSelectionDialog dialog;
        if (configurations.length == 1) {
            CompletableFuture.runAsync(() -> DebugUITools.launch((ILaunchConfiguration)configurations[0], (String)mode));
        } else if (configurations.length > 1 && (dialog = new LaunchConfigurationSelectionDialog(Display.getDefault().getActiveShell(), (Object)configurations)).open() == 0) {
            this.launch(mode, Arrays.asList(dialog.getResult()).toArray(new ILaunchConfiguration[dialog.getResult().length]));
        }
    }

    private ILaunchConfiguration[] getLaunchConfigurations(File file) {
        if (file == null || !this.canLaunch(file)) {
            return new ILaunchConfiguration[0];
        }
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType configType = launchManager.getLaunchConfigurationType(this.launchConfigTypeId);
        try {
            ILaunchConfiguration[] existing = (ILaunchConfiguration[])Arrays.stream(launchManager.getLaunchConfigurations(configType)).filter(launchConfig -> this.match((ILaunchConfiguration)launchConfig, file)).toArray(ILaunchConfiguration[]::new);
            if (existing.length != 0) {
                return existing;
            }
            String configName = launchManager.generateLaunchConfigurationName(file.getAbsolutePath());
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, configName);
            this.configureLaunchConfiguration(file, wc);
            return new ILaunchConfiguration[]{wc};
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"error", (String)e.getMessage(), (IStatus)e.getStatus());
            Activator.getDefault().getLog().log(e.getStatus());
            return new ILaunchConfiguration[0];
        }
    }

    public abstract void configureLaunchConfiguration(File var1, ILaunchConfigurationWorkingCopy var2);

    public abstract boolean match(ILaunchConfiguration var1, File var2);
}

