/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.prefs;

import java.util.List;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.connection.RepositoryInfo;
import org.eclipse.codewind.ui.CodewindUIPlugin;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.prefs.RepositoryManagementComposite;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class RepositoryManagementDialog
extends TitleAreaDialog {
    private final CodewindConnection connection;
    private final List<RepositoryInfo> repoList;
    private RepositoryManagementComposite repoComposite;

    public RepositoryManagementDialog(Shell parentShell, CodewindConnection connection, List<RepositoryInfo> repoList) {
        super(parentShell);
        this.connection = connection;
        this.repoList = repoList;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.RepoMgmtDialogTitle);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createButtonBar(Composite parent) {
        return super.createButtonBar(parent);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitleImage(CodewindUIPlugin.getImage("codewindBanner.png"));
        this.setTitle(Messages.RepoMgmtDialogTitle);
        this.setMessage(Messages.RepoMgmtDialogMessage);
        Composite content = (Composite)super.createDialogArea(parent);
        content.setLayout((Layout)new GridLayout());
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        this.repoComposite = new RepositoryManagementComposite(content, this.connection, this.repoList);
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = 250;
        this.repoComposite.setLayoutData(data);
        return parent;
    }

    public boolean hasChanges() {
        return this.repoComposite.hasChanges();
    }

    public IStatus updateRepos(IProgressMonitor monitor) {
        return this.repoComposite.updateRepos(monitor);
    }
}

