/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.CodewindEclipseApplication;
import org.eclipse.codewind.core.internal.CoreUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.constants.AppStatus;
import org.eclipse.codewind.core.internal.constants.ProjectLanguage;
import org.eclipse.codewind.core.internal.constants.StartMode;
import org.eclipse.codewind.ui.CodewindUIPlugin;
import org.eclipse.codewind.ui.internal.IDEUtil;
import org.eclipse.codewind.ui.internal.actions.ImportProjectAction;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.actions.SelectionProviderAction;

public class RestartDebugModeAction
extends SelectionProviderAction {
    public static final String ACTION_ID = "org.eclipse.codewind.ui.restartDebugModeAction";
    protected CodewindEclipseApplication app;

    public RestartDebugModeAction(ISelectionProvider selectionProvider) {
        super(selectionProvider, Messages.RestartInDebugMode);
        this.setImageDescriptor(CodewindUIPlugin.getImageDescriptor("elcl16/debug_exc.png"));
        this.selectionChanged(this.getStructuredSelection());
    }

    public void selectionChanged(IStructuredSelection sel) {
        Object obj;
        if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof CodewindEclipseApplication) {
            this.app = (CodewindEclipseApplication)obj;
            if (this.app.isAvailable() && this.app.supportsDebug()) {
                this.setEnabled(this.app.getAppStatus() == AppStatus.STARTED || this.app.getAppStatus() == AppStatus.STARTING);
                return;
            }
        }
        this.setEnabled(false);
    }

    public void run() {
        if (this.app == null) {
            Logger.logError((String)"RestartDebugModeAction ran but no application was selected");
            return;
        }
        if (this.app.projectLanguage == ProjectLanguage.LANGUAGE_JAVA) {
            final IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.app.name);
            if (project == null || !project.exists()) {
                int result = IDEUtil.openQuestionCancelDialog(NLS.bind((String)Messages.ProjectNotImportedDialogTitle, (Object)this.app.name), NLS.bind((String)Messages.ProjectNotImportedDialogMsg, (Object)this.app.name));
                if (result == 0) {
                    ImportProjectAction.importProject((CodewindApplication)this.app);
                } else if (result == 2) {
                    return;
                }
            } else if (!project.isOpen()) {
                int result = IDEUtil.openQuestionCancelDialog(NLS.bind((String)Messages.ProjectClosedDialogTitle, (Object)this.app.name), NLS.bind((String)Messages.ProjectClosedDialogMsg, (Object)this.app.name));
                if (result == 0) {
                    Job job = new Job(NLS.bind((String)Messages.ProjectOpenJob, (Object)this.app.name)){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                project.open(monitor);
                                return Status.OK_STATUS;
                            }
                            catch (CoreException e) {
                                return new Status(4, "org.eclipse.codewind.ui", NLS.bind((String)Messages.ProjectOpenError, (Object)RestartDebugModeAction.this.app.name), (Throwable)e);
                            }
                        }
                    };
                    job.setPriority(30);
                    job.schedule();
                } else if (result == 2) {
                    return;
                }
            }
        }
        try {
            this.app.clearDebugger();
            if (this.app.getProjectCapabilities().supportsDebugMode()) {
                this.app.connection.requestProjectRestart((CodewindApplication)this.app, StartMode.DEBUG.startMode);
            } else if (this.app.getProjectCapabilities().supportsDebugNoInitMode()) {
                this.app.connection.requestProjectRestart((CodewindApplication)this.app, StartMode.DEBUG_NO_INIT.startMode);
            } else {
                Logger.logError((String)("Project restart in debug mode requested but project does not support any debug modes: " + this.app.name));
            }
        }
        catch (Exception e) {
            Logger.logError((String)("Error initiating restart for project: " + this.app.name), (Throwable)e);
            CoreUtil.openDialog((boolean)true, (String)Messages.ErrorOnRestartDialogTitle, (String)e.getMessage());
            return;
        }
    }

    public boolean showAction() {
        return this.app != null && this.app.isAvailable() && this.app.supportsDebug();
    }
}

