/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.filewatchers.core.internal;

import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.eclipse.codewind.filewatchers.core.FWLogger;
import org.eclipse.codewind.filewatchers.core.Filewatcher;

public class DebugTimer {
    private final FWLogger log = FWLogger.getInstance();
    private Timer timer_synch_lock;
    private final Object lock = new Object();
    private final long TIME_TO_WAIT_IN_MSECS = TimeUnit.MILLISECONDS.convert(30L, TimeUnit.MINUTES);
    private final Filewatcher parent;

    public DebugTimer(Filewatcher parent) {
        this.parent = parent;
        this.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule() {
        Object object = this.lock;
        synchronized (object) {
            this.timer_synch_lock = new Timer(DebugTimer.class.getName(), true);
            this.timer_synch_lock.schedule((TimerTask)new DebugTimerTask(), this.TIME_TO_WAIT_IN_MSECS);
        }
    }

    private class DebugTimerTask
    extends TimerTask {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Optional<String> result = null;
            try {
                result = DebugTimer.this.parent.generateDebugString();
                if (!result.isPresent()) {
                    return;
                }
                for (String str : result.get().split("\n")) {
                    DebugTimer.this.log.logInfo("[status] " + str);
                }
            }
            finally {
                if (result == null || result.isPresent()) {
                    DebugTimer.this.schedule();
                }
            }
        }
    }
}

