/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.wizards;

import org.eclipse.codewind.ui.CodewindUIPlugin;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ProjectDeployedDialog
extends TitleAreaDialog {
    private final IPath projectPath;
    private Behaviour selectedBehaviour = Behaviour.REMOVE;

    public ProjectDeployedDialog(Shell parentShell, IPath projectPath) {
        super(parentShell);
        this.projectPath = projectPath;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ProjectDeployedDialogShell);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitleImage(CodewindUIPlugin.getImage("codewindBanner.png"));
        this.setTitle(Messages.ProjectDeployedDialogTitle);
        this.setMessage(NLS.bind((String)Messages.ProjectDeployedDialogMessage, (Object)this.projectPath.toOSString()));
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 11;
        layout.marginWidth = 9;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 7;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.widthHint = 200;
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        Group radioGroup = new Group(composite, 0);
        layout = new GridLayout();
        layout.marginHeight = 11;
        layout.marginWidth = 9;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 7;
        radioGroup.setLayout((Layout)layout);
        radioGroup.setText(Messages.ProjectDeployedDialogGroupLabel);
        radioGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button removeButton = this.addBehaviourButton((Composite)radioGroup, Messages.ProjectDeployedDialogRemoveLabel, Messages.ProjectDeployedDialogRemoveTooltip, Behaviour.REMOVE);
        this.addBehaviourButton((Composite)radioGroup, Messages.ProjectDeployedDialogDisableLabel, Messages.ProjectDeployedDialogDisableTooltip, Behaviour.DISABLE);
        this.addBehaviourButton((Composite)radioGroup, Messages.ProjectDeployedDialogMaintainLabel, Messages.ProjectDeployedDialogMaintainTooltip, Behaviour.MAINTAIN);
        this.selectedBehaviour = Behaviour.REMOVE;
        removeButton.setSelection(true);
        return composite;
    }

    private Button addBehaviourButton(Composite parent, String label, String tooltip, final Behaviour behaviour) {
        final Button button = new Button(parent, 16);
        button.setText(label);
        button.setToolTipText(tooltip);
        button.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (button.getSelection()) {
                    ProjectDeployedDialog.this.selectedBehaviour = behaviour;
                }
            }
        });
        return button;
    }

    public Behaviour getSelectedBehaviour() {
        return this.selectedBehaviour;
    }

    protected Point getInitialSize() {
        Point point = super.getInitialSize();
        return new Point(750, point.y);
    }

    public static enum Behaviour {
        REMOVE,
        DISABLE,
        MAINTAIN;

    }
}

