/*
 * Copyright 2014 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=25
//  date=$Date: 2014-02-25 22:16:49 +0100 (Tue, 25 Feb 2014) $
//  number=$Revision: 9791 $
//  type=ms

/**
 * Localized names for the "ms" locale.
 */
public class LocalizedNamesImpl_ms extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "ZA",
        "AL",
        "DZ",
        "AS",
        "US",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "SA",
        "AR",
        "AM",
        "AW",
        "AU",
        "AT",
        "AZ",
        "BS",
        "BH",
        "BD",
        "BB",
        "NL",
        "BQ",
        "BY",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BT",
        "BO",
        "BA",
        "BW",
        "BR",
        "BN",
        "BG",
        "BF",
        "BI",
        "CM",
        "CV",
        "EA",
        "TD",
        "CL",
        "CN",
        "CO",
        "KM",
        "CG",
        "CD",
        "CR",
        "CI",
        "HR",
        "CU",
        "CW",
        "CY",
        "DK",
        "DG",
        "DJ",
        "DM",
        "EC",
        "SV",
        "AE",
        "ER",
        "EE",
        "ET",
        "FJ",
        "PH",
        "FI",
        "GA",
        "GM",
        "GE",
        "GH",
        "GI",
        "GL",
        "GD",
        "GP",
        "GU",
        "GT",
        "GG",
        "GF",
        "GN",
        "GW",
        "GQ",
        "GY",
        "HT",
        "HN",
        "HK",
        "HU",
        "IS",
        "IN",
        "ID",
        "IR",
        "IQ",
        "IE",
        "IM",
        "IL",
        "IT",
        "JM",
        "JP",
        "DE",
        "JE",
        "JO",
        "CA",
        "KZ",
        "KH",
        "KE",
        "GS",
        "AX",
        "IC",
        "KY",
        "CC",
        "CK",
        "FK",
        "FO",
        "MP",
        "MH",
        "PN",
        "SB",
        "UM",
        "TC",
        "VI",
        "VG",
        "EU",
        "KI",
        "KR",
        "KP",
        "XK",
        "VA",
        "KW",
        "KG",
        "LA",
        "LV",
        "LS",
        "LR",
        "LY",
        "LI",
        "LT",
        "LB",
        "LU",
        "MO",
        "MK",
        "MG",
        "MA",
        "MW",
        "MY",
        "MV",
        "ML",
        "MT",
        "MQ",
        "MR",
        "MU",
        "YT",
        "EG",
        "MX",
        "FM",
        "MD",
        "MC",
        "MN",
        "ME",
        "MS",
        "MZ",
        "MM",
        "NA",
        "NR",
        "NP",
        "AN",
        "NC",
        "NZ",
        "NI",
        "NE",
        "NG",
        "NU",
        "NF",
        "NO",
        "QO",
        "OM",
        "PK",
        "PW",
        "PA",
        "PG",
        "PY",
        "FR",
        "PE",
        "PL",
        "PF",
        "PT",
        "PR",
        "AC",
        "BV",
        "CP",
        "HM",
        "CX",
        "QA",
        "CF",
        "CZ",
        "DO",
        "RE",
        "RO",
        "RU",
        "RW",
        "EH",
        "BL",
        "SH",
        "KN",
        "LC",
        "MF",
        "PM",
        "VC",
        "WS",
        "SM",
        "ST",
        "SN",
        "ES",
        "RS",
        "SC",
        "SL",
        "SG",
        "SX",
        "SK",
        "SI",
        "SO",
        "LK",
        "SD",
        "SS",
        "SR",
        "SJ",
        "SZ",
        "SE",
        "CH",
        "SY",
        "TW",
        "TJ",
        "TZ",
        "TH",
        "TL",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TN",
        "TR",
        "TM",
        "TV",
        "UG",
        "UA",
        "GB",
        "UY",
        "UZ",
        "VU",
        "VE",
        "VN",
        "WF",
        "IO",
        "PS",
        "TF",
        "YE",
        "GR",
        "ZM",
        "ZW",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Dunia");
    namesMap.put("002", "Afrika");
    namesMap.put("003", "Amerika Utara");
    namesMap.put("005", "Amerika Selatan");
    namesMap.put("011", "Afrika Barat");
    namesMap.put("013", "Amerika Tengah");
    namesMap.put("014", "Afrika Timur");
    namesMap.put("015", "Afrika Utara");
    namesMap.put("017", "Afrika Tengah");
    namesMap.put("018", "Selatan Afrika");
    namesMap.put("019", "Amerika");
    namesMap.put("021", "Utara Amerika");
    namesMap.put("030", "Asia Timur");
    namesMap.put("034", "Asia Selatan");
    namesMap.put("035", "Asia Tenggara");
    namesMap.put("039", "Eropah Selatan");
    namesMap.put("057", "Wilayah Mikronesia");
    namesMap.put("061", "Polinesia");
    namesMap.put("143", "Asia Tengah");
    namesMap.put("145", "Asia Barat");
    namesMap.put("150", "Eropah");
    namesMap.put("151", "Eropah Timur");
    namesMap.put("154", "Eropah Utara");
    namesMap.put("155", "Eropah Barat");
    namesMap.put("419", "Amerika Latin");
    namesMap.put("AC", "Pulau Ascension");
    namesMap.put("AE", "Emiriah Arab Bersatu");
    namesMap.put("AG", "Antigua dan Barbuda");
    namesMap.put("AQ", "Antartika");
    namesMap.put("AX", "Kepulauan Aland");
    namesMap.put("BA", "Bosnia dan Herzegovina");
    namesMap.put("BQ", "Belanda Caribbean");
    namesMap.put("BV", "Pulau Bouvet");
    namesMap.put("CA", "Kanada");
    namesMap.put("CC", "Kepulauan Cocos (Keeling)");
    namesMap.put("CD", "Congo - Kinshasa");
    namesMap.put("CF", "Republik Afrika Tengah");
    namesMap.put("CG", "Congo - Brazzaville");
    namesMap.put("CI", "Cote d’Ivoire");
    namesMap.put("CK", "Kepulauan Cook");
    namesMap.put("CP", "Pulau Clipperton");
    namesMap.put("CW", "Curacao");
    namesMap.put("CX", "Pulau Krismas");
    namesMap.put("CZ", "Republik Czech");
    namesMap.put("DE", "Jerman");
    namesMap.put("DO", "Republik Dominica");
    namesMap.put("EA", "Ceuta dan Melilla");
    namesMap.put("EG", "Mesir");
    namesMap.put("EH", "Sahara Barat");
    namesMap.put("ES", "Sepanyol");
    namesMap.put("EU", "Kesatuan Eropah");
    namesMap.put("FK", "Kepulauan Falkland");
    namesMap.put("FO", "Kepulauan Faroe");
    namesMap.put("FR", "Perancis");
    namesMap.put("GF", "Guiana Perancis");
    namesMap.put("GQ", "Guinea Khatulistiwa");
    namesMap.put("GR", "Yunani");
    namesMap.put("GS", "Kepualaun Georgia Selatan dan Sandwich Selatan");
    namesMap.put("GW", "Guinea Bissau");
    namesMap.put("HM", "Pulau Heard dan Kepulauan McDonald");
    namesMap.put("IC", "Kepulauan Canary");
    namesMap.put("IO", "Wilayah Lautan Hindi British");
    namesMap.put("IT", "Itali");
    namesMap.put("JP", "Jepun");
    namesMap.put("KH", "Kemboja");
    namesMap.put("KN", "Saint Kitts dan Nevis");
    namesMap.put("KP", "Korea Utara");
    namesMap.put("KR", "Korea Selatan");
    namesMap.put("KY", "Kepulauan Cayman");
    namesMap.put("LB", "Lubnan");
    namesMap.put("MA", "Maghribi");
    namesMap.put("MG", "Madagaskar");
    namesMap.put("MH", "Kepulauan Marshall");
    namesMap.put("MK", "Macedonia");
    namesMap.put("MP", "Kepulauan Mariana Utara");
    namesMap.put("MZ", "Mozambik");
    namesMap.put("NL", "Belanda");
    namesMap.put("PF", "Polinesia Perancis");
    namesMap.put("PH", "Filipina");
    namesMap.put("PM", "Saint Pierre dan Miquelon");
    namesMap.put("PN", "Kepulauan Pitcairn");
    namesMap.put("PS", "Wilayah Palestin");
    namesMap.put("QO", "Oceania Terpencil");
    namesMap.put("RE", "Reunion");
    namesMap.put("RU", "Rusia");
    namesMap.put("SA", "Arab Saudi");
    namesMap.put("SB", "Kepulauan Solomon");
    namesMap.put("SG", "Singapura");
    namesMap.put("SJ", "Svalbard dan Jan Mayen");
    namesMap.put("SR", "Surinam");
    namesMap.put("SS", "Sudan Selatan");
    namesMap.put("ST", "Sao Tome dan Principe");
    namesMap.put("TC", "Kepulauan Turks dan Caicos");
    namesMap.put("TF", "Wilayah Selatan Perancis");
    namesMap.put("TL", "Timor Timur");
    namesMap.put("TR", "Turki");
    namesMap.put("TT", "Trinidad dan Tobago");
    namesMap.put("UM", "Kepulauan Terpencil A.S.");
    namesMap.put("US", "Amerika Syarikat");
    namesMap.put("VA", "Kota Vatican");
    namesMap.put("VC", "Saint Vincent dan Grenadines");
    namesMap.put("VG", "Kepulauan Virgin British");
    namesMap.put("VI", "Kepulauan Virgin A.S.");
    namesMap.put("WF", "Wallis dan Futuna");
    namesMap.put("YE", "Yaman");
    namesMap.put("ZA", "Afrika Selatan");
    namesMap.put("ZZ", "Wilayah Tidak Diketahui");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Dunia",
        "002": "Afrika",
        "003": "Amerika Utara",
        "005": "Amerika Selatan",
        "011": "Afrika Barat",
        "013": "Amerika Tengah",
        "014": "Afrika Timur",
        "015": "Afrika Utara",
        "017": "Afrika Tengah",
        "018": "Selatan Afrika",
        "019": "Amerika",
        "021": "Utara Amerika",
        "030": "Asia Timur",
        "034": "Asia Selatan",
        "035": "Asia Tenggara",
        "039": "Eropah Selatan",
        "057": "Wilayah Mikronesia",
        "061": "Polinesia",
        "143": "Asia Tengah",
        "145": "Asia Barat",
        "150": "Eropah",
        "151": "Eropah Timur",
        "154": "Eropah Utara",
        "155": "Eropah Barat",
        "419": "Amerika Latin",
        "AC": "Pulau Ascension",
        "AE": "Emiriah Arab Bersatu",
        "AG": "Antigua dan Barbuda",
        "AQ": "Antartika",
        "AX": "Kepulauan Aland",
        "BA": "Bosnia dan Herzegovina",
        "BQ": "Belanda Caribbean",
        "BV": "Pulau Bouvet",
        "CA": "Kanada",
        "CC": "Kepulauan Cocos (Keeling)",
        "CD": "Congo - Kinshasa",
        "CF": "Republik Afrika Tengah",
        "CG": "Congo - Brazzaville",
        "CI": "Cote d’Ivoire",
        "CK": "Kepulauan Cook",
        "CP": "Pulau Clipperton",
        "CW": "Curacao",
        "CX": "Pulau Krismas",
        "CZ": "Republik Czech",
        "DE": "Jerman",
        "DO": "Republik Dominica",
        "EA": "Ceuta dan Melilla",
        "EG": "Mesir",
        "EH": "Sahara Barat",
        "ES": "Sepanyol",
        "EU": "Kesatuan Eropah",
        "FK": "Kepulauan Falkland",
        "FO": "Kepulauan Faroe",
        "FR": "Perancis",
        "GF": "Guiana Perancis",
        "GQ": "Guinea Khatulistiwa",
        "GR": "Yunani",
        "GS": "Kepualaun Georgia Selatan dan Sandwich Selatan",
        "GW": "Guinea Bissau",
        "HM": "Pulau Heard dan Kepulauan McDonald",
        "IC": "Kepulauan Canary",
        "IO": "Wilayah Lautan Hindi British",
        "IT": "Itali",
        "JP": "Jepun",
        "KH": "Kemboja",
        "KN": "Saint Kitts dan Nevis",
        "KP": "Korea Utara",
        "KR": "Korea Selatan",
        "KY": "Kepulauan Cayman",
        "LB": "Lubnan",
        "MA": "Maghribi",
        "MG": "Madagaskar",
        "MH": "Kepulauan Marshall",
        "MK": "Macedonia",
        "MP": "Kepulauan Mariana Utara",
        "MZ": "Mozambik",
        "NL": "Belanda",
        "PF": "Polinesia Perancis",
        "PH": "Filipina",
        "PM": "Saint Pierre dan Miquelon",
        "PN": "Kepulauan Pitcairn",
        "PS": "Wilayah Palestin",
        "QO": "Oceania Terpencil",
        "RE": "Reunion",
        "RU": "Rusia",
        "SA": "Arab Saudi",
        "SB": "Kepulauan Solomon",
        "SG": "Singapura",
        "SJ": "Svalbard dan Jan Mayen",
        "SR": "Surinam",
        "SS": "Sudan Selatan",
        "ST": "Sao Tome dan Principe",
        "TC": "Kepulauan Turks dan Caicos",
        "TF": "Wilayah Selatan Perancis",
        "TL": "Timor Timur",
        "TR": "Turki",
        "TT": "Trinidad dan Tobago",
        "UM": "Kepulauan Terpencil A.S.",
        "US": "Amerika Syarikat",
        "VA": "Kota Vatican",
        "VC": "Saint Vincent dan Grenadines",
        "VG": "Kepulauan Virgin British",
        "VI": "Kepulauan Virgin A.S.",
        "WF": "Wallis dan Futuna",
        "YE": "Yaman",
        "ZA": "Afrika Selatan",
        "ZZ": "Wilayah Tidak Diketahui"
    };
  }-*/;
}
