/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.geometryext;

import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Math3D;
import org.eclipse.draw3d.geometry.Math3DBase;
import org.eclipse.draw3d.geometry.Math3DCache;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.geometry.Vector3fImpl;

public class Plane {
    private Vector3fImpl m_n = new Vector3fImpl();
    private Vector3fImpl m_p = new Vector3fImpl();

    public Vector3f getNormal(Vector3f o_result) {
        Vector3f result = o_result;
        if (result == null) {
            result = new Vector3fImpl();
        }
        result.set((IVector3f)this.m_n);
        return result;
    }

    public Math3DBase.Side getSide(IVector3f i_point) {
        return Math3D.getSideOfPoint((IVector3f)this.m_p, (IVector3f)this.m_n, (IVector3f)i_point);
    }

    public Vector3f intersectionWithLine(IVector3f i_la, IVector3f i_lb, Vector3f o_result) {
        return Math3D.lineIntersectsPlane((IVector3f)i_la, (IVector3f)i_lb, (IVector3f)this.m_p, (IVector3f)this.m_n, (Vector3f)o_result);
    }

    public Vector3f intersectionWithRay(IVector3f i_rayOrigin, IVector3f i_rayDirection, Vector3f o_result) {
        return Math3D.rayIntersectsPlane((IVector3f)i_rayOrigin, (IVector3f)i_rayDirection, (IVector3f)this.m_p, (IVector3f)this.m_n, (Vector3f)o_result);
    }

    public Vector3f intersectionWithSegment(IVector3f i_segmentPoint1, IVector3f i_segmentPoint2, Vector3f o_result) {
        return Math3D.segmentIntersectsPlane((IVector3f)i_segmentPoint1, (IVector3f)i_segmentPoint2, (IVector3f)this.m_p, (IVector3f)this.m_n, (Vector3f)o_result);
    }

    public boolean isInFront(IVector3f i_point) {
        return Math3D.getSideOfPoint((IVector3f)this.m_p, (IVector3f)this.m_n, (IVector3f)i_point) == Math3DBase.Side.FRONT;
    }

    public boolean onSameSide(IVector3f i_point1, IVector3f i_point2) {
        return Math3D.getSideOfPoint((IVector3f)this.m_p, (IVector3f)this.m_n, (IVector3f)i_point1) == Math3D.getSideOfPoint((IVector3f)this.m_p, (IVector3f)this.m_n, (IVector3f)i_point2);
    }

    public void set(IVector3f i_planePoint, IVector3f i_planeNormal) {
        if (i_planePoint == null) {
            throw new NullPointerException("i_planePoint must not be null");
        }
        if (i_planeNormal == null) {
            throw new NullPointerException("i_planeNormal must not be null");
        }
        this.m_p.set(i_planePoint);
        this.m_n.set(i_planeNormal);
    }

    public boolean set(IVector3f i_p0, IVector3f i_p1, IVector3f i_p2) {
        Vector3f normal;
        Vector3f p0p2;
        Vector3f p0p1;
        block6: {
            if (i_p0 == null) {
                throw new NullPointerException("i_p0 must not be null");
            }
            if (i_p1 == null) {
                throw new NullPointerException("i_p1 must not be null");
            }
            if (i_p2 == null) {
                throw new NullPointerException("i_p2 must not be null");
            }
            p0p1 = Math3DCache.getVector3f();
            p0p2 = Math3DCache.getVector3f();
            normal = Math3DCache.getVector3f();
            try {
                Math3D.sub((IVector3f)i_p1, (IVector3f)i_p0, (Vector3f)p0p1);
                Math3D.sub((IVector3f)i_p2, (IVector3f)i_p0, (Vector3f)p0p2);
                Math3D.cross((IVector3f)p0p1, (IVector3f)p0p2, (Vector3f)normal);
                if (normal.lengthSquared() != 0.0f) break block6;
            }
            catch (Throwable throwable) {
                Math3DCache.returnVector3f((Vector3f[])new Vector3f[]{p0p1, p0p2, normal});
                throw throwable;
            }
            Math3DCache.returnVector3f((Vector3f[])new Vector3f[]{p0p1, p0p2, normal});
            return false;
        }
        Math3D.normalise((IVector3f)normal, (Vector3f)normal);
        this.set(i_p0, (IVector3f)normal);
        Math3DCache.returnVector3f((Vector3f[])new Vector3f[]{p0p1, p0p2, normal});
        return true;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Plane[position: ");
        buf.append(this.m_p);
        buf.append(", normal: ");
        buf.append(this.m_n);
        buf.append("]");
        return buf.toString();
    }
}

