/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.model.engine;

import java.io.Serializable;
import org.ascape.model.Scape;
import org.ascape.model.engine.AgentOrderMutableStrategy;
import org.ascape.model.engine.AgentOrderStrategy;
import org.ascape.model.engine.DefaultRuleSelector;
import org.ascape.model.engine.ExecutionStrategy;
import org.ascape.model.engine.FlaggedTourAgentSelector;
import org.ascape.model.engine.IncrementalExecutionStrategy;
import org.ascape.model.engine.IterateAllRuleSelector;
import org.ascape.model.engine.NoIterateAllRuleSelector;
import org.ascape.model.engine.ParallelExecutionStrategy;
import org.ascape.model.engine.PartialRuleSelector;
import org.ascape.model.engine.PartialTourAgentSelector;
import org.ascape.model.engine.RandomAgentSelector;
import org.ascape.model.engine.RuleOrderMutableStrategy;
import org.ascape.model.engine.RuleOrderStrategy;
import org.ascape.model.engine.RuleOrderUpdateMutableStrategy;
import org.ascape.model.engine.RuleOrderUpdateStrategy;
import org.ascape.model.engine.TourAgentSelector;
import org.ascape.model.engine.UpdateRuleSelector;
import org.ascape.model.rule.ExecuteThenUpdate;
import org.ascape.model.rule.Rule;
import org.ascape.util.ResetableIterator;

public class StrategyFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean anyRandom;
    private boolean anyIterateAll;
    private boolean anyDelete;
    private boolean anyUpdate;
    private Scape scape;
    private Object[] rules;
    private int threads;
    private int iterationCount;
    private ExecutionStrategy strategy;

    public StrategyFactory(Scape scape, Object[] rules, int threads) {
        this.rules = rules;
        this.scape = scape;
        this.threads = threads;
    }

    public final ExecutionStrategy getStrategy() {
        if (this.strategy == null) {
            this.strategy = this.createStrategy();
        }
        return this.strategy;
    }

    public ExecutionStrategy createStrategy() {
        ExecutionStrategy strategy = null;
        this.iterationCount = this.scape.getSize();
        if (this.scape.getAgentsPerIteration() != -1) {
            this.iterationCount = Math.min(this.iterationCount, this.scape.getAgentsPerIteration());
        }
        this.analyzeRules();
        IncrementalExecutionStrategy mainStrategy = this.selectMainStrategy();
        mainStrategy.setAgentIterator(this.selectAgentIterator());
        this.assignAgentSelector(mainStrategy);
        mainStrategy.setRuleSelector(new DefaultRuleSelector(this.rules));
        RuleOrderStrategy updateStrategy = null;
        if (this.scape.getExecutionOrder() == -1 && this.anyUpdate) {
            updateStrategy = !this.scape.isMutable() ? new RuleOrderUpdateStrategy(this) : new RuleOrderUpdateMutableStrategy(this);
            updateStrategy.setAgentSelector(mainStrategy.getAgentSelector());
            updateStrategy.setRuleSelector(new UpdateRuleSelector(this.rules));
        }
        if ((this.iterationCount < this.scape.getSize() || this.scape.getExecutionStyle() == 2) && this.anyIterateAll) {
            if (this.scape.getExecutionStyle() == 1 && this.scape.getExecutionOrder() == -2) {
                mainStrategy.setAgentSelector(new FlaggedTourAgentSelector(mainStrategy, this.iterationCount));
                mainStrategy.setRuleSelector(new PartialRuleSelector(this.rules, (FlaggedTourAgentSelector)mainStrategy.getAgentSelector()));
            } else {
                ParallelExecutionStrategy iterateAllStrategy = (ParallelExecutionStrategy)mainStrategy.clone();
                mainStrategy.setRuleSelector(new NoIterateAllRuleSelector(this.rules));
                iterateAllStrategy.setAgentSelector(new TourAgentSelector(mainStrategy));
                iterateAllStrategy.setRuleSelector(new IterateAllRuleSelector(this.rules));
                strategy = mainStrategy.chain(iterateAllStrategy);
            }
        }
        if (this.scape.getExecutionOrder() == -1 && this.anyUpdate) {
            strategy = mainStrategy.chain(updateStrategy);
        }
        if (strategy == null) {
            strategy = mainStrategy;
        }
        return strategy;
    }

    private void assignAgentSelector(IncrementalExecutionStrategy strategy) {
        strategy.agentSelector = this.scape.getExecutionStyle() == 1 ? (this.iterationCount >= this.scape.getSize() ? new TourAgentSelector(strategy) : new PartialTourAgentSelector(strategy, this.iterationCount)) : new RandomAgentSelector(strategy, this.iterationCount);
    }

    private IncrementalExecutionStrategy selectMainStrategy() {
        ParallelExecutionStrategy strategy = this.scape.getExecutionOrder() == -2 ? (!this.scape.isMutable() || !this.anyDelete ? new AgentOrderStrategy(this) : new AgentOrderMutableStrategy(this)) : (!this.scape.isMutable() ? new RuleOrderStrategy(this) : new RuleOrderMutableStrategy(this));
        return strategy;
    }

    private ResetableIterator selectAgentIterator() {
        ResetableIterator agentIterator = this.anyRandom || this.iterationCount < this.scape.getSize() ? this.scape.getSpace().safeRandomIterator() : this.scape.getSpace().safeIterator();
        return agentIterator;
    }

    private void analyzeRules() {
        this.anyRandom = false;
        this.anyIterateAll = false;
        this.anyDelete = false;
        this.anyUpdate = false;
        int i = 0;
        while (i < this.rules.length) {
            if (((Rule)this.rules[i]).isRandomExecution()) {
                this.anyRandom = true;
            }
            if (((Rule)this.rules[i]).isIterateAll()) {
                this.anyIterateAll = true;
            }
            if (((Rule)this.rules[i]).isCauseRemoval()) {
                this.anyDelete = true;
            }
            if ((Rule)this.rules[i] instanceof ExecuteThenUpdate) {
                this.anyUpdate = true;
            }
            ++i;
        }
    }

    public final boolean isAnyDelete() {
        return this.anyDelete;
    }

    public final boolean isAnyIterateAll() {
        return this.anyIterateAll;
    }

    public final boolean isAnyRandom() {
        return this.anyRandom;
    }

    public final Scape getScape() {
        return this.scape;
    }

    public final Object[] getRules() {
        return this.rules;
    }

    public final int getThreads() {
        return this.threads;
    }
}

