/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.shaded.framework.imps;

import java.util.concurrent.Callable;
import org.apache.curator.shaded.RetryLoop;
import org.apache.curator.shaded.drivers.OperationTrace;
import org.apache.curator.shaded.framework.api.Pathable;
import org.apache.curator.shaded.framework.api.StatPathable;
import org.apache.curator.shaded.framework.api.TempGetDataBuilder;
import org.apache.curator.shaded.framework.imps.CuratorFrameworkImpl;
import org.apache.zookeeper.data.Stat;

class TempGetDataBuilderImpl
implements TempGetDataBuilder {
    private final CuratorFrameworkImpl client;
    private Stat responseStat;
    private boolean decompress;

    TempGetDataBuilderImpl(CuratorFrameworkImpl client) {
        this.client = client;
        this.responseStat = null;
        this.decompress = false;
    }

    @Override
    public StatPathable<byte[]> decompressed() {
        this.decompress = true;
        return this;
    }

    @Override
    public Pathable<byte[]> storingStatIn(Stat stat) {
        this.responseStat = stat;
        return this;
    }

    @Override
    public byte[] forPath(String path) throws Exception {
        final String localPath = this.client.fixForNamespace(path);
        OperationTrace trace = this.client.getZookeeperClient().startAdvancedTracer("GetDataBuilderImpl-Foreground");
        byte[] responseData = RetryLoop.callWithRetry(this.client.getZookeeperClient(), new Callable<byte[]>(){

            @Override
            public byte[] call() throws Exception {
                return TempGetDataBuilderImpl.this.client.getZooKeeper().getData(localPath, false, TempGetDataBuilderImpl.this.responseStat);
            }
        });
        trace.setResponseBytesLength(responseData).setPath(path).setStat(this.responseStat).commit();
        return this.decompress ? this.client.getCompressionProvider().decompress(path, responseData) : responseData;
    }
}

