/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;

final class Serialization {
    private Serialization() {
    }

    static int readCount(ObjectInputStream stream) throws IOException {
        return stream.readInt();
    }

    static <K, V> void writeMap(Map<K, V> map2, ObjectOutputStream stream) throws IOException {
        stream.writeInt(map2.size());
        for (Map.Entry<K, V> entry2 : map2.entrySet()) {
            stream.writeObject(entry2.getKey());
            stream.writeObject(entry2.getValue());
        }
    }

    static <K, V> void populateMap(Map<K, V> map2, ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int size2 = stream.readInt();
        Serialization.populateMap(map2, stream, size2);
    }

    static <K, V> void populateMap(Map<K, V> map2, ObjectInputStream stream, int size2) throws IOException, ClassNotFoundException {
        for (int i = 0; i < size2; ++i) {
            Object key = stream.readObject();
            Object value2 = stream.readObject();
            map2.put(key, value2);
        }
    }

    static <E> void writeMultiset(Multiset<E> multiset, ObjectOutputStream stream) throws IOException {
        int entryCount = multiset.entrySet().size();
        stream.writeInt(entryCount);
        for (Multiset.Entry<E> entry2 : multiset.entrySet()) {
            stream.writeObject(entry2.getElement());
            stream.writeInt(entry2.getCount());
        }
    }

    static <E> void populateMultiset(Multiset<E> multiset, ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int distinctElements = stream.readInt();
        Serialization.populateMultiset(multiset, stream, distinctElements);
    }

    static <E> void populateMultiset(Multiset<E> multiset, ObjectInputStream stream, int distinctElements) throws IOException, ClassNotFoundException {
        for (int i = 0; i < distinctElements; ++i) {
            Object element = stream.readObject();
            int count2 = stream.readInt();
            multiset.add(element, count2);
        }
    }

    static <K, V> void writeMultimap(Multimap<K, V> multimap, ObjectOutputStream stream) throws IOException {
        stream.writeInt(multimap.asMap().size());
        for (Map.Entry<K, Collection<V>> entry2 : multimap.asMap().entrySet()) {
            stream.writeObject(entry2.getKey());
            stream.writeInt(entry2.getValue().size());
            for (V value2 : entry2.getValue()) {
                stream.writeObject(value2);
            }
        }
    }

    static <K, V> void populateMultimap(Multimap<K, V> multimap, ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int distinctKeys = stream.readInt();
        Serialization.populateMultimap(multimap, stream, distinctKeys);
    }

    static <K, V> void populateMultimap(Multimap<K, V> multimap, ObjectInputStream stream, int distinctKeys) throws IOException, ClassNotFoundException {
        for (int i = 0; i < distinctKeys; ++i) {
            Object key = stream.readObject();
            Collection<V> values = multimap.get(key);
            int valueCount = stream.readInt();
            for (int j = 0; j < valueCount; ++j) {
                Object value2 = stream.readObject();
                values.add(value2);
            }
        }
    }

    static <T> FieldSetter<T> getFieldSetter(Class<T> clazz, String fieldName) {
        try {
            Field field2 = clazz.getDeclaredField(fieldName);
            return new FieldSetter(field2);
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
    }

    static final class FieldSetter<T> {
        private final Field field;

        private FieldSetter(Field field2) {
            this.field = field2;
            field2.setAccessible(true);
        }

        void set(T instance, Object value2) {
            try {
                this.field.set(instance, value2);
            }
            catch (IllegalAccessException impossible) {
                throw new AssertionError((Object)impossible);
            }
        }

        void set(T instance, int value2) {
            try {
                this.field.set(instance, value2);
            }
            catch (IllegalAccessException impossible) {
                throw new AssertionError((Object)impossible);
            }
        }
    }
}

