/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.api;

import java.util.Map;
import org.apache.hive.hcatalog.api.HCatPartition;
import org.apache.hive.hcatalog.api.HCatTable;
import org.apache.hive.hcatalog.common.HCatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HCatAddPartitionDesc {
    private static final Logger LOG = LoggerFactory.getLogger(HCatAddPartitionDesc.class);
    private HCatPartition hcatPartition;
    String dbName;
    String tableName;
    String location;
    Map<String, String> partitionKeyValues;

    private HCatAddPartitionDesc(HCatPartition hcatPartition) {
        this.hcatPartition = hcatPartition;
    }

    private HCatAddPartitionDesc(String dbName, String tableName, String location, Map<String, String> partitionKeyValues) {
        this.hcatPartition = null;
        this.dbName = dbName;
        this.tableName = tableName;
        this.location = location;
        this.partitionKeyValues = partitionKeyValues;
    }

    HCatPartition getHCatPartition() {
        return this.hcatPartition;
    }

    HCatPartition getHCatPartition(HCatTable hcatTable) throws HCatException {
        assert (this.hcatPartition == null) : "hcatPartition should have been null at this point.";
        assert (this.dbName.equalsIgnoreCase(hcatTable.getDbName())) : "DB names don't match.";
        assert (this.tableName.equalsIgnoreCase(hcatTable.getTableName())) : "Table names don't match.";
        return new HCatPartition(hcatTable, this.partitionKeyValues, this.location);
    }

    @Deprecated
    public String getLocation() {
        return this.hcatPartition == null ? this.location : this.hcatPartition.getLocation();
    }

    @Deprecated
    public Map<String, String> getPartitionSpec() {
        return this.hcatPartition == null ? this.partitionKeyValues : this.hcatPartition.getPartitionKeyValMap();
    }

    @Deprecated
    public String getTableName() {
        return this.hcatPartition == null ? this.tableName : this.hcatPartition.getTableName();
    }

    @Deprecated
    public String getDatabaseName() {
        return this.hcatPartition == null ? this.dbName : this.hcatPartition.getDatabaseName();
    }

    public String toString() {
        return "HCatAddPartitionDesc [" + this.hcatPartition + "]";
    }

    @Deprecated
    public static Builder create(String dbName, String tableName, String location, Map<String, String> partSpec) throws HCatException {
        LOG.error("Unsupported! HCatAddPartitionDesc requires HCatTable to be specified explicitly.");
        return new Builder(dbName, tableName, location, partSpec);
    }

    public static Builder create(HCatPartition partition) throws HCatException {
        return new Builder(partition);
    }

    public static class Builder {
        private HCatPartition hcatPartition;
        String dbName;
        String tableName;
        String location;
        Map<String, String> partitionSpec;

        private Builder(HCatPartition hcatPartition) {
            this.hcatPartition = hcatPartition;
        }

        @Deprecated
        private Builder(String dbName, String tableName, String location, Map<String, String> partitionSpec) {
            this.hcatPartition = null;
            this.dbName = dbName;
            this.tableName = tableName;
            this.location = location;
            this.partitionSpec = partitionSpec;
        }

        public HCatAddPartitionDesc build() throws HCatException {
            return this.hcatPartition == null ? new HCatAddPartitionDesc(this.dbName, this.tableName, this.location, this.partitionSpec) : new HCatAddPartitionDesc(this.hcatPartition);
        }
    }
}

