/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.apiextensions.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.api.model.apiextensions.v1.ConversionResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ConversionResponseFluent<A extends ConversionResponseFluent<A>>
extends BaseFluent<A> {
    private List<Object> convertedObjects = new ArrayList<Object>();
    private Status result;
    private String uid;
    private Map<String, Object> additionalProperties;

    public ConversionResponseFluent() {
    }

    public ConversionResponseFluent(ConversionResponse instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ConversionResponse instance) {
        ConversionResponse conversionResponse = instance = instance != null ? instance : new ConversionResponse();
        if (instance != null) {
            this.withConvertedObjects(instance.getConvertedObjects());
            this.withResult(instance.getResult());
            this.withUid(instance.getUid());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToConvertedObjects(int index, Object item) {
        if (this.convertedObjects == null) {
            this.convertedObjects = new ArrayList<Object>();
        }
        this.convertedObjects.add(index, item);
        return (A)((Object)this);
    }

    public A setToConvertedObjects(int index, Object item) {
        if (this.convertedObjects == null) {
            this.convertedObjects = new ArrayList<Object>();
        }
        this.convertedObjects.set(index, item);
        return (A)((Object)this);
    }

    public A addToConvertedObjects(Object ... items) {
        if (this.convertedObjects == null) {
            this.convertedObjects = new ArrayList<Object>();
        }
        for (Object item : items) {
            this.convertedObjects.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToConvertedObjects(Collection<Object> items) {
        if (this.convertedObjects == null) {
            this.convertedObjects = new ArrayList<Object>();
        }
        for (Object item : items) {
            this.convertedObjects.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromConvertedObjects(Object ... items) {
        if (this.convertedObjects == null) {
            return (A)((Object)this);
        }
        for (Object item : items) {
            this.convertedObjects.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConvertedObjects(Collection<Object> items) {
        if (this.convertedObjects == null) {
            return (A)((Object)this);
        }
        for (Object item : items) {
            this.convertedObjects.remove(item);
        }
        return (A)((Object)this);
    }

    public List<Object> getConvertedObjects() {
        return this.convertedObjects;
    }

    public Object getConvertedObject(int index) {
        return this.convertedObjects.get(index);
    }

    public Object getFirstConvertedObject() {
        return this.convertedObjects.get(0);
    }

    public Object getLastConvertedObject() {
        return this.convertedObjects.get(this.convertedObjects.size() - 1);
    }

    public Object getMatchingConvertedObject(Predicate<Object> predicate) {
        for (Object item : this.convertedObjects) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingConvertedObject(Predicate<Object> predicate) {
        for (Object item : this.convertedObjects) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConvertedObjects(List<Object> convertedObjects) {
        if (convertedObjects != null) {
            this.convertedObjects = new ArrayList<Object>();
            for (Object item : convertedObjects) {
                this.addToConvertedObjects(item);
            }
        } else {
            this.convertedObjects = null;
        }
        return (A)((Object)this);
    }

    public A withConvertedObjects(Object ... convertedObjects) {
        if (this.convertedObjects != null) {
            this.convertedObjects.clear();
            this._visitables.remove((Object)"convertedObjects");
        }
        if (convertedObjects != null) {
            for (Object item : convertedObjects) {
                this.addToConvertedObjects(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasConvertedObjects() {
        return this.convertedObjects != null && !this.convertedObjects.isEmpty();
    }

    public Status getResult() {
        return this.result;
    }

    public A withResult(Status result) {
        this.result = result;
        return (A)((Object)this);
    }

    public boolean hasResult() {
        return this.result != null;
    }

    public String getUid() {
        return this.uid;
    }

    public A withUid(String uid) {
        this.uid = uid;
        return (A)((Object)this);
    }

    public boolean hasUid() {
        return this.uid != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConversionResponseFluent that = (ConversionResponseFluent)((Object)o);
        if (!Objects.equals(this.convertedObjects, that.convertedObjects)) {
            return false;
        }
        if (!Objects.equals(this.result, that.result)) {
            return false;
        }
        if (!Objects.equals(this.uid, that.uid)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.convertedObjects, this.result, this.uid, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.convertedObjects != null && !this.convertedObjects.isEmpty()) {
            sb.append("convertedObjects:");
            sb.append(this.convertedObjects + ",");
        }
        if (this.result != null) {
            sb.append("result:");
            sb.append(this.result + ",");
        }
        if (this.uid != null) {
            sb.append("uid:");
            sb.append(this.uid + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

