/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.nio.ByteOrder;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.types.UTF8String;

public final class XXH64 {
    private static final boolean isBigEndian = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN);
    private static final long PRIME64_1 = -7046029288634856825L;
    private static final long PRIME64_2 = -4417276706812531889L;
    private static final long PRIME64_3 = 1609587929392839161L;
    private static final long PRIME64_4 = -8796714831421723037L;
    private static final long PRIME64_5 = 2870177450012600261L;
    private final long seed;

    public XXH64(long seed) {
        this.seed = seed;
    }

    public String toString() {
        return "xxHash64(seed=" + this.seed + ")";
    }

    public long hashInt(int input) {
        return XXH64.hashInt(input, this.seed);
    }

    public static long hashInt(int input, long seed) {
        long hash = seed + 2870177450012600261L + 4L;
        hash ^= ((long)input & 0xFFFFFFFFL) * -7046029288634856825L;
        hash = Long.rotateLeft(hash, 23) * -4417276706812531889L + 1609587929392839161L;
        return XXH64.fmix(hash);
    }

    public long hashLong(long input) {
        return XXH64.hashLong(input, this.seed);
    }

    public static long hashLong(long input, long seed) {
        long hash = seed + 2870177450012600261L + 8L;
        hash ^= Long.rotateLeft(input * -4417276706812531889L, 31) * -7046029288634856825L;
        hash = Long.rotateLeft(hash, 27) * -7046029288634856825L + -8796714831421723037L;
        return XXH64.fmix(hash);
    }

    public long hashUnsafeWords(Object base, long offset, int length) {
        return XXH64.hashUnsafeWords(base, offset, length, this.seed);
    }

    public static long hashUnsafeWords(Object base, long offset, int length, long seed) {
        assert (length % 8 == 0) : "lengthInBytes must be a multiple of 8 (word-aligned)";
        long hash = XXH64.hashBytesByWords(base, offset, length, seed);
        return XXH64.fmix(hash);
    }

    public long hashUnsafeBytes(Object base, long offset, int length) {
        return XXH64.hashUnsafeBytes(base, offset, length, this.seed);
    }

    public static long hashUnsafeBytes(Object base, long offset, int length, long seed) {
        long end;
        assert (length >= 0) : "lengthInBytes cannot be negative";
        long hash = XXH64.hashBytesByWords(base, offset, length, seed);
        if ((offset += (long)(length & 0xFFFFFFF8)) + 4L <= (end = offset + (long)length)) {
            int k1 = Platform.getInt((Object)base, (long)offset);
            if (isBigEndian) {
                k1 = Integer.reverseBytes(k1);
            }
            hash ^= ((long)k1 & 0xFFFFFFFFL) * -7046029288634856825L;
            hash = Long.rotateLeft(hash, 23) * -4417276706812531889L + 1609587929392839161L;
            offset += 4L;
        }
        while (offset < end) {
            hash ^= ((long)Platform.getByte((Object)base, (long)offset) & 0xFFL) * 2870177450012600261L;
            hash = Long.rotateLeft(hash, 11) * -7046029288634856825L;
            ++offset;
        }
        return XXH64.fmix(hash);
    }

    public static long hashUTF8String(UTF8String str, long seed) {
        return XXH64.hashUnsafeBytes(str.getBaseObject(), str.getBaseOffset(), str.numBytes(), seed);
    }

    private static long fmix(long hash) {
        hash ^= hash >>> 33;
        hash *= -4417276706812531889L;
        hash ^= hash >>> 29;
        hash *= 1609587929392839161L;
        hash ^= hash >>> 32;
        return hash;
    }

    private static long hashBytesByWords(Object base, long offset, int length, long seed) {
        long hash;
        long limit;
        long end = offset + (long)length;
        if (length >= 32) {
            limit = end - 32L;
            long v1 = seed + -7046029288634856825L + -4417276706812531889L;
            long v2 = seed + -4417276706812531889L;
            long v3 = seed;
            long v4 = seed - -7046029288634856825L;
            do {
                long k1 = Platform.getLong((Object)base, (long)offset);
                long k2 = Platform.getLong((Object)base, (long)(offset + 8L));
                long k3 = Platform.getLong((Object)base, (long)(offset + 16L));
                long k4 = Platform.getLong((Object)base, (long)(offset + 24L));
                if (isBigEndian) {
                    k1 = Long.reverseBytes(k1);
                    k2 = Long.reverseBytes(k2);
                    k3 = Long.reverseBytes(k3);
                    k4 = Long.reverseBytes(k4);
                }
                v1 = Long.rotateLeft(v1 + k1 * -4417276706812531889L, 31) * -7046029288634856825L;
                v2 = Long.rotateLeft(v2 + k2 * -4417276706812531889L, 31) * -7046029288634856825L;
                v3 = Long.rotateLeft(v3 + k3 * -4417276706812531889L, 31) * -7046029288634856825L;
                v4 = Long.rotateLeft(v4 + k4 * -4417276706812531889L, 31) * -7046029288634856825L;
            } while ((offset += 32L) <= limit);
            hash = Long.rotateLeft(v1, 1) + Long.rotateLeft(v2, 7) + Long.rotateLeft(v3, 12) + Long.rotateLeft(v4, 18);
            v1 *= -4417276706812531889L;
            v1 = Long.rotateLeft(v1, 31);
            hash ^= (v1 *= -7046029288634856825L);
            hash = hash * -7046029288634856825L + -8796714831421723037L;
            v2 *= -4417276706812531889L;
            v2 = Long.rotateLeft(v2, 31);
            hash ^= (v2 *= -7046029288634856825L);
            hash = hash * -7046029288634856825L + -8796714831421723037L;
            v3 *= -4417276706812531889L;
            v3 = Long.rotateLeft(v3, 31);
            hash ^= (v3 *= -7046029288634856825L);
            hash = hash * -7046029288634856825L + -8796714831421723037L;
            v4 *= -4417276706812531889L;
            v4 = Long.rotateLeft(v4, 31);
            hash ^= (v4 *= -7046029288634856825L);
            hash = hash * -7046029288634856825L + -8796714831421723037L;
        } else {
            hash = seed + 2870177450012600261L;
        }
        hash += (long)length;
        limit = end - 8L;
        while (offset <= limit) {
            long k1 = Platform.getLong((Object)base, (long)offset);
            if (isBigEndian) {
                k1 = Long.reverseBytes(k1);
            }
            hash ^= Long.rotateLeft(k1 * -4417276706812531889L, 31) * -7046029288634856825L;
            hash = Long.rotateLeft(hash, 27) * -7046029288634856825L + -8796714831421723037L;
            offset += 8L;
        }
        return hash;
    }
}

