/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.HllSketchEstimate$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(expr) - Returns the estimated number of unique values given the binary representation\n    of a Datasketches HllSketch. ", examples="\n    Examples:\n      > SELECT _FUNC_(hll_sketch_agg(col)) FROM VALUES (1), (1), (2), (2), (3) tab(col);\n       3\n  ", group="misc_funcs", since="3.5.0")
@ScalaSignature(bytes="\u0006\u0005\u0005uf\u0001\u0002\u000e\u001c\u0001\"B\u0001\u0002\u0013\u0001\u0003\u0016\u0004%\t!\u0013\u0005\t\u001b\u0002\u0011\t\u0012)A\u0005\u0015\")a\n\u0001C\u0001\u001f\")!\u000b\u0001C!'\")q\u000b\u0001C)1\")1\f\u0001C!9\")Q\r\u0001C!M\")\u0001\u000f\u0001C!c\")Q\u000f\u0001C!m\"9A\u0010AA\u0001\n\u0003i\b\u0002C@\u0001#\u0003%\t!!\u0001\t\u0013\u0005]\u0001!!A\u0005B\u0005e\u0001\"CA\u0015\u0001\u0005\u0005I\u0011AA\u0016\u0011%\t\u0019\u0004AA\u0001\n\u0003\t)\u0004C\u0005\u0002<\u0001\t\t\u0011\"\u0011\u0002>!I\u00111\n\u0001\u0002\u0002\u0013\u0005\u0011Q\n\u0005\n\u0003#\u0002\u0011\u0011!C!\u0003'B\u0011\"a\u0016\u0001\u0003\u0003%\t%!\u0017\b\u0013\u0005u4$!A\t\u0002\u0005}d\u0001\u0003\u000e\u001c\u0003\u0003E\t!!!\t\r9#B\u0011AAM\u0011%\tY\nFA\u0001\n\u000b\ni\nC\u0005\u0002 R\t\t\u0011\"!\u0002\"\"I\u0011Q\u0015\u000b\u0002\u0002\u0013\u0005\u0015q\u0015\u0005\n\u0003g#\u0012\u0011!C\u0005\u0003k\u0013\u0011\u0003\u00137m'.,Go\u00195FgRLW.\u0019;f\u0015\taR$A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u0010 \u0003!\u0019\u0017\r^1msN$(B\u0001\u0011\"\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003E\r\nQa\u001d9be.T!\u0001J\u0013\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0013aA8sO\u000e\u00011C\u0002\u0001*[M2D\b\u0005\u0002+W5\t1$\u0003\u0002-7\tyQK\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u0002/c5\tqF\u0003\u000217\u000591m\u001c3fO\u0016t\u0017B\u0001\u001a0\u0005=\u0019u\u000eZ3hK:4\u0015\r\u001c7cC\u000e\\\u0007C\u0001\u00165\u0013\t)4DA\tFqB,7\r^:J]B,H\u000fV=qKN\u0004\"a\u000e\u001e\u000e\u0003aR\u0011!O\u0001\u0006g\u000e\fG.Y\u0005\u0003wa\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002>\u000b:\u0011ah\u0011\b\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0003\u0003\u001e\na\u0001\u0010:p_Rt\u0014\"A\u001d\n\u0005\u0011C\u0014a\u00029bG.\fw-Z\u0005\u0003\r\u001e\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!\u0001\u0012\u001d\u0002\u000b\rD\u0017\u000e\u001c3\u0016\u0003)\u0003\"AK&\n\u00051[\"AC#yaJ,7o]5p]\u000611\r[5mI\u0002\na\u0001P5oSRtDC\u0001)R!\tQ\u0003\u0001C\u0003I\u0007\u0001\u0007!*\u0001\bok2d\u0017J\u001c;pY\u0016\u0014\u0018M\u001c;\u0016\u0003Q\u0003\"aN+\n\u0005YC$a\u0002\"p_2,\u0017M\\\u0001\u0015o&$\bNT3x\u0007\"LG\u000eZ%oi\u0016\u0014h.\u00197\u0015\u0005AK\u0006\"\u0002.\u0006\u0001\u0004Q\u0015\u0001\u00038fo\u000eC\u0017\u000e\u001c3\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001^!\tq&M\u0004\u0002`AB\u0011q\bO\u0005\u0003Cb\na\u0001\u0015:fI\u00164\u0017BA2e\u0005\u0019\u0019FO]5oO*\u0011\u0011\rO\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#A4\u0011\u0007uB'.\u0003\u0002j\u000f\n\u00191+Z9\u0011\u0005-tW\"\u00017\u000b\u00055|\u0012!\u0002;za\u0016\u001c\u0018BA8m\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-\u0001\u0005eCR\fG+\u001f9f+\u0005\u0011\bCA6t\u0013\t!HN\u0001\u0005ECR\fG+\u001f9f\u00031qW\u000f\u001c7TC\u001a,WI^1m)\t9(\u0010\u0005\u00028q&\u0011\u0011\u0010\u000f\u0002\u0004\u0003:L\b\"B>\n\u0001\u00049\u0018!B5oaV$\u0018\u0001B2paf$\"\u0001\u0015@\t\u000f!S\u0001\u0013!a\u0001\u0015\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u0002U\rQ\u0015QA\u0016\u0003\u0003\u000f\u0001B!!\u0003\u0002\u00145\u0011\u00111\u0002\u0006\u0005\u0003\u001b\ty!A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u0003\u001d\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0016\u0005-!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u0007\u0011\t\u0005u\u0011qE\u0007\u0003\u0003?QA!!\t\u0002$\u0005!A.\u00198h\u0015\t\t)#\u0001\u0003kCZ\f\u0017bA2\u0002 \u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\u0006\t\u0004o\u0005=\u0012bAA\u0019q\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019q/a\u000e\t\u0013\u0005eb\"!AA\u0002\u00055\u0012a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002@A)\u0011\u0011IA$o6\u0011\u00111\t\u0006\u0004\u0003\u000bB\u0014AC2pY2,7\r^5p]&!\u0011\u0011JA\"\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007Q\u000by\u0005\u0003\u0005\u0002:A\t\t\u00111\u0001x\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005m\u0011Q\u000b\u0005\n\u0003s\t\u0012\u0011!a\u0001\u0003[\ta!Z9vC2\u001cHc\u0001+\u0002\\!A\u0011\u0011\b\n\u0002\u0002\u0003\u0007q\u000fK\n\u0001\u0003?\n)'a\u001a\u0002l\u00055\u0014\u0011OA:\u0003o\nI\bE\u0002+\u0003CJ1!a\u0019\u001c\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!\u001b\u0002\u0003\u000fQ\u0001\u0005\t\u0011!?\u001a+fjQ0)Kb\u0004(/\u000b\u0011.AI+G/\u001e:og\u0002\"\b.\u001a\u0011fgRLW.\u0019;fI\u0002rW/\u001c2fe\u0002zg\rI;oSF,X\r\t<bYV,7\u000fI4jm\u0016t\u0007\u0005\u001e5fA\tLg.\u0019:zAI,\u0007O]3tK:$\u0018\r^5p]*\u0001\u0003\u0005\t\u0011pM\u0002\n\u0007\u0005R1uCN\\W\r^2iKN\u0004\u0003\n\u001c7TW\u0016$8\r\u001b\u0018!\u0003!)\u00070Y7qY\u0016\u001c\u0018EAA8\u0003MT\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006\u0006\u001b7m?N\\W\r^2i?\u0006<w\rK2pY&J\u0003E\u0012*P\u001b\u00022\u0016\tT+F'\u0002B\u0013'\u000b\u0017!QEJC\u0006\t\u00153S1\u0002\u0003FM\u0015-A!\u001a\u0014\u0006\t;bE\"\u001aw\u000e\\\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AMR\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003k\n!\"\\5tG~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\t\tY(A\u00034]Ur\u0003'A\tIY2\u001c6.\u001a;dQ\u0016\u001bH/[7bi\u0016\u0004\"A\u000b\u000b\u0014\u000bQ\t\u0019)a$\u0011\r\u0005\u0015\u00151\u0012&Q\u001b\t\t9IC\u0002\u0002\nb\nqA];oi&lW-\u0003\u0003\u0002\u000e\u0006\u001d%!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ocA!\u0011\u0011SAL\u001b\t\t\u0019J\u0003\u0003\u0002\u0016\u0006\r\u0012AA5p\u0013\r1\u00151\u0013\u000b\u0003\u0003\u007f\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u00037\tQ!\u00199qYf$2\u0001UAR\u0011\u0015Au\u00031\u0001K\u0003\u001d)h.\u00199qYf$B!!+\u00020B!q'a+K\u0013\r\ti\u000b\u000f\u0002\u0007\u001fB$\u0018n\u001c8\t\u0011\u0005E\u0006$!AA\u0002A\u000b1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\t9\f\u0005\u0003\u0002\u001e\u0005e\u0016\u0002BA^\u0003?\u0011aa\u00142kK\u000e$\b")
public class HllSketchEstimate
extends UnaryExpression
implements CodegenFallback,
ExpectsInputTypes,
Serializable {
    private final Expression child;

    public static Option<Expression> unapply(HllSketchEstimate x$0) {
        return HllSketchEstimate$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<Expression, A> andThen(Function1<HllSketchEstimate, A> g) {
        return HllSketchEstimate$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, HllSketchEstimate> compose(Function1<A$, Expression> g) {
        return HllSketchEstimate$.MODULE$.compose(g);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public HllSketchEstimate withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    @Override
    public String prettyName() {
        return "hll_sketch_estimate";
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)BinaryType$.MODULE$, (List)Nil$.MODULE$);
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    @Override
    public Object nullSafeEval(Object input) {
        Long l;
        byte[] buffer = (byte[])input;
        try {
            l = BoxesRunTime.boxToLong((long)Math.round(HllSketch.heapify((Memory)Memory.wrap((byte[])buffer)).getEstimate()));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof SketchesArgumentException ? true : throwable2 instanceof Error) {
                throw QueryExecutionErrors$.MODULE$.hllInvalidInputSketchBuffer(this.prettyName());
            }
            throw throwable;
        }
        return l;
    }

    public HllSketchEstimate copy(Expression child) {
        return new HllSketchEstimate(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "HllSketchEstimate";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof HllSketchEstimate;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof HllSketchEstimate)) return false;
        boolean bl = true;
        if (!bl) return false;
        HllSketchEstimate hllSketchEstimate = (HllSketchEstimate)x$1;
        Expression expression = this.child();
        Expression expression2 = hllSketchEstimate.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!hllSketchEstimate.canEqual(this)) return false;
        return true;
    }

    public HllSketchEstimate(Expression child) {
        this.child = child;
        CodegenFallback.$init$(this);
        ExpectsInputTypes.$init$(this);
    }
}

